/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.Page;
import org.apache.camel.component.wordpress.api.model.PageSearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressServicePages;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressCrudServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.PagesSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordpressServicePagesAdapter
extends AbstractWordpressCrudServiceAdapter<PagesSPI, Page, PageSearchCriteria>
implements WordpressServicePages {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordpressServicePagesAdapter.class);

    public WordpressServicePagesAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<PagesSPI> getSpiType() {
        return PagesSPI.class;
    }

    @Override
    public List<Page> list(PageSearchCriteria c) {
        LOGGER.debug("Calling list pages: searchCriteria {}", (Object)c);
        Objects.requireNonNull(c, "Please provide a search criteria");
        return ((PagesSPI)this.getSpi()).list(this.getApiVersion(), c.getContext(), c.getPage(), c.getPerPage(), c.getSearch(), c.getAfter(), c.getAuthor(), c.getAuthorExclude(), c.getBefore(), c.getExclude(), c.getInclude(), c.getMenuOrder(), c.getOffset(), c.getOrder(), c.getOrderBy(), c.getParent(), c.getParentExclude(), c.getSlug(), c.getStatus(), c.getFilter());
    }

    @Override
    public Page retrieve(Integer pageId, Context context, String password) {
        LOGGER.debug("Calling retrieve: postId {};  context: {}", (Object)pageId, (Object)context);
        if (pageId <= 0) {
            throw new IllegalArgumentException("Please provide a non zero post id");
        }
        return ((PagesSPI)this.getSpi()).retrieve(this.getApiVersion(), pageId, context, password);
    }

    @Override
    protected Page doCreate(Page object) {
        return ((PagesSPI)this.getSpi()).create(this.getApiVersion(), object);
    }

    @Override
    protected Page doDelete(Integer id) {
        return ((PagesSPI)this.getSpi()).delete(this.getApiVersion(), id, false);
    }

    @Override
    protected Page doUpdate(Integer id, Page object) {
        return ((PagesSPI)this.getSpi()).update(this.getApiVersion(), id, object);
    }

    @Override
    protected Page doRetrieve(Integer entityID, Context context) {
        return ((PagesSPI)this.getSpi()).retrieve(this.getApiVersion(), entityID, context, null);
    }
}

