/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.producer;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.component.workday.producer.WorkdayDefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkdayReportProducer
extends WorkdayDefaultProducer {
    public static final String WORKDAY_RASS_URL_TEMPLATE = "https://%s/ccx/service/customreport2/%s%s";
    private static final Logger LOG = LoggerFactory.getLogger(WorkdayReportProducer.class);

    public WorkdayReportProducer(WorkdayEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public String prepareUri(WorkdayConfiguration configuration) {
        Map<String, Object> parameters = configuration.getParameters();
        StringBuilder stringBuilder = new StringBuilder(configuration.getPath());
        stringBuilder.append("?");
        if (parameters.size() > 0) {
            String params = parameters.keySet().stream().map(k -> k + "=" + parameters.get(k)).collect(Collectors.joining("&"));
            stringBuilder.append(params);
            stringBuilder.append("&");
        }
        stringBuilder.append("format=");
        stringBuilder.append(configuration.getReportFormat());
        String uriString = String.format(WORKDAY_RASS_URL_TEMPLATE, configuration.getHost(), configuration.getTenant(), stringBuilder.toString());
        return uriString;
    }
}

