/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.component.workday.auth.AuthClientForIntegration;
import org.apache.camel.component.workday.auth.AuthenticationClient;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultProducer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;

public abstract class WorkdayDefaultProducer
extends DefaultProducer {
    @Metadata(description="The workday URL", javaType="String")
    public static final String WORKDAY_URL_HEADER = "CamelWorkdayURL";
    private final WorkdayEndpoint endpoint;
    private final AuthenticationClient authenticationClient;

    public WorkdayDefaultProducer(WorkdayEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.authenticationClient = new AuthClientForIntegration(this.endpoint.getWorkdayConfiguration());
    }

    public WorkdayEndpoint getEndpoint() {
        return (WorkdayEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PoolingHttpClientConnectionManager httpClientConnectionManager = this.endpoint.getWorkdayConfiguration().getHttpConnectionManager();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        String workdayUri = this.prepareUri(this.endpoint.getWorkdayConfiguration());
        HttpGet httpGet = new HttpGet(workdayUri);
        this.authenticationClient.configure(httpClient, (HttpUriRequest)httpGet);
        try {
            httpClient.execute((ClassicHttpRequest)httpGet, httpResponse -> {
                if (httpResponse.getCode() != 200) {
                    throw new IllegalStateException("Got the invalid http status value '" + new StatusLine((HttpResponse)httpResponse) + "' as the result of the RAAS '" + workdayUri + "'");
                }
                try {
                    String report = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)httpResponse.getEntity().getContent());
                    if (report.isEmpty()) {
                        throw new IllegalStateException("Got the unexpected value '" + report + "' as the result of the report '" + workdayUri + "'");
                    }
                    exchange.getIn().setBody((Object)report);
                    exchange.getIn().setHeader(WORKDAY_URL_HEADER, (Object)workdayUri);
                    return null;
                }
                catch (NoTypeConversionAvailableException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            });
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }

    public abstract String prepareUri(WorkdayConfiguration var1) throws Exception;
}

