/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;

public class XChangeMetaDataProducer
extends DefaultProducer {
    public XChangeMetaDataProducer(XChangeEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public XChangeEndpoint getEndpoint() {
        return (XChangeEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        XChangeEndpoint endpoint = this.getEndpoint();
        XChangeConfiguration.XChangeMethod method = endpoint.getConfiguration().getMethod();
        if (XChangeConfiguration.XChangeMethod.currencies == method) {
            List<Currency> body = endpoint.getCurrencies();
            exchange.getMessage().setBody(body);
        } else if (XChangeConfiguration.XChangeMethod.currencyPairs == method) {
            List<CurrencyPair> body = endpoint.getCurrencyPairs();
            exchange.getMessage().setBody(body);
        } else if (XChangeConfiguration.XChangeMethod.currencyMetaData == method) {
            Currency curr = (Currency)exchange.getMessage().getHeader("Currency", Currency.class);
            curr = curr != null ? curr : (Currency)exchange.getMessage().getBody(Currency.class);
            curr = curr != null ? curr : endpoint.getConfiguration().getCurrency();
            CurrencyMetaData body = endpoint.getCurrencyMetaData(curr);
            exchange.getMessage().setBody((Object)body);
        } else if (XChangeConfiguration.XChangeMethod.currencyPairMetaData == method) {
            CurrencyPair pair = (CurrencyPair)exchange.getIn().getHeader("CurrencyPair", CurrencyPair.class);
            pair = pair != null ? pair : (CurrencyPair)exchange.getMessage().getBody(CurrencyPair.class);
            pair = pair != null ? pair : endpoint.getConfiguration().getCurrencyPair();
            CurrencyPairMetaData body = endpoint.getCurrencyPairMetaData(pair);
            exchange.getMessage().setBody((Object)body);
        }
    }
}

