/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.out;

import java.io.IOException;
import java.io.Writer;
import org.apache.camel.xml.io.XMLWriter;

public class BaseWriter {
    protected final XMLWriter writer;
    protected final String namespace;
    protected boolean namespaceWritten;

    public BaseWriter(Writer writer, String namespace) throws IOException {
        this.writer = new XMLWriter(writer);
        this.namespace = namespace;
    }

    protected void startElement(String name) throws IOException {
        this.writer.startElement(name);
        if (!this.namespaceWritten && this.namespace != null) {
            this.writer.addAttribute("xmlns", this.namespace);
            this.namespaceWritten = true;
        }
    }

    protected void endElement() throws IOException {
        this.writer.endElement();
    }

    protected void text(String text) throws IOException {
        this.writer.writeText(text);
    }

    protected void attribute(String name, String value) throws IOException {
        this.writer.addAttribute(name, value);
    }
}

