/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.io;

import java.io.InputStream;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.IOHelper;

public class XmlPullParserLocationException
extends RuntimeException {
    private final int row;
    private final int column;
    private final Resource resource;

    public XmlPullParserLocationException(String s, Resource resource, int row, int column, Throwable cause) {
        super(XmlPullParserLocationException.createMessage(s, resource, row, column, cause), cause);
        this.row = row;
        this.column = column;
        this.resource = resource;
    }

    public int getLineNumber() {
        return this.row;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public Resource getResource() {
        return this.resource;
    }

    private static String createMessage(String s, Resource resource, int row, int column, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append(cause.getMessage()).append("\n");
        if (resource != null) {
            sb.append("in ").append(resource.getLocation()).append(", line ").append(row).append(", column ").append(column).append(":\n");
            try {
                String line = IOHelper.loadTextLine((InputStream)resource.getInputStream(), (int)row);
                if (line != null) {
                    sb.append(line).append("\n");
                    if (column > 1) {
                        String pad = " ".repeat(column - 2);
                        sb.append(pad);
                    }
                    sb.append("^\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

