/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xmlsecurity.XmlCommand;
import org.apache.camel.component.xmlsecurity.XmlSignatureEndpoint;
import org.apache.camel.component.xmlsecurity.XmlSignerEndpoint;
import org.apache.camel.component.xmlsecurity.XmlVerifierEndpoint;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public class XmlSignatureComponent
extends UriEndpointComponent {
    @Metadata(label="advanced")
    private XmlSignerConfiguration signerConfiguration;
    @Metadata(label="advanced")
    private XmlVerifierConfiguration verifierConfiguration;

    public XmlSignatureComponent() {
        super(XmlSignatureEndpoint.class);
    }

    public XmlSignatureComponent(CamelContext context) {
        super(context, XmlSignatureEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XmlSignatureEndpoint endpoint;
        String name;
        String scheme;
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
        try {
            URI u = new URI(remaining);
            scheme = u.getScheme();
            name = u.getPath();
        }
        catch (Exception e) {
            throw new MalformedURLException(String.format("An invalid xmlsecurity uri was provided '%s'. Check the uri matches the format xmlsecurity:sign://<name> or xmlsecurity:verify:<name>", uri));
        }
        if ("sign".equals(scheme)) {
            XmlSignerConfiguration config = this.getSignerConfiguration().copy();
            endpoint = new XmlSignerEndpoint(uri, this, config);
        } else if ("verify".equals(scheme)) {
            XmlVerifierConfiguration config = this.getVerifierConfiguration().copy();
            endpoint = new XmlVerifierEndpoint(uri, this, config);
        } else {
            throw new IllegalStateException(String.format("Endpoint uri '%s' is wrong configured. Operation '%s' is not supported. Supported operations are: sign, verify", uri, scheme));
        }
        this.setProperties(endpoint.getConfiguration(), parameters);
        endpoint.getConfiguration().setCamelContext(this.getCamelContext());
        endpoint.setCommand(XmlCommand.valueOf(scheme));
        endpoint.setName(name);
        return endpoint;
    }

    public XmlSignerConfiguration getSignerConfiguration() {
        if (this.signerConfiguration == null) {
            this.signerConfiguration = new XmlSignerConfiguration();
        }
        return this.signerConfiguration;
    }

    public void setSignerConfiguration(XmlSignerConfiguration signerConfiguration) {
        this.signerConfiguration = signerConfiguration;
    }

    public XmlVerifierConfiguration getVerifierConfiguration() {
        if (this.verifierConfiguration == null) {
            this.verifierConfiguration = new XmlVerifierConfiguration();
        }
        return this.verifierConfiguration;
    }

    public void setVerifierConfiguration(XmlVerifierConfiguration verifierConfiguration) {
        this.verifierConfiguration = verifierConfiguration;
    }
}

