/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.XmppBinding;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;

public class XmppMessage
extends DefaultMessage {
    private Stanza xmppPacket;

    public XmppMessage() {
        this(new Message());
    }

    public XmppMessage(Message message) {
        this.xmppPacket = message;
    }

    public XmppMessage(Stanza stanza) {
        this.xmppPacket = stanza;
    }

    public String toString() {
        if (this.xmppPacket != null) {
            return "XmppMessage: " + this.xmppPacket;
        }
        return "XmppMessage: " + this.getBody();
    }

    public Message getXmppMessage() {
        return this.xmppPacket instanceof Message ? (Message)this.xmppPacket : null;
    }

    public void setXmppMessage(Message xmppMessage) {
        this.xmppPacket = xmppMessage;
    }

    public Stanza getXmppPacket() {
        return this.xmppPacket;
    }

    public void setXmppPacket(Stanza xmppPacket) {
        this.xmppPacket = xmppPacket;
    }

    public XmppMessage newInstance() {
        XmppMessage answer = new XmppMessage();
        answer.setCamelContext(this.getCamelContext());
        return answer;
    }

    protected Object createBody() {
        XmppBinding binding;
        if (this.xmppPacket != null && (binding = (XmppBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), XmppBinding.class)) != null) {
            return this.getHeader("CamelXmppDoc") == null ? binding.extractBodyFromXmpp(this.getExchange(), this.xmppPacket) : this.getHeader("CamelXmppDoc");
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        XmppBinding binding;
        if (this.xmppPacket != null && (binding = (XmppBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), XmppBinding.class)) != null) {
            map.putAll(binding.extractHeadersFromXmpp(this.xmppPacket, this.getExchange()));
        }
    }
}

