/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmpp.XmppBinding;
import org.apache.camel.component.xmpp.XmppComponent;
import org.apache.camel.component.xmpp.XmppConstants;
import org.apache.camel.component.xmpp.XmppConsumer;
import org.apache.camel.component.xmpp.XmppDirectProducer;
import org.apache.camel.component.xmpp.XmppGroupChatProducer;
import org.apache.camel.component.xmpp.XmppLogger;
import org.apache.camel.component.xmpp.XmppPrivateChatProducer;
import org.apache.camel.component.xmpp.XmppPubSubProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.0", scheme="xmpp", title="XMPP", syntax="xmpp:host:port/participant", alternativeSyntax="xmpp:user:password@host:port/participant", category={Category.CHAT, Category.MESSAGING}, headersClass=XmppConstants.class)
public class XmppEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(XmppEndpoint.class);
    private volatile XMPPTCPConnection connection;
    private XmppBinding binding;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    @Metadata(required=true)
    private int port;
    @UriPath(label="common")
    private String participant;
    @UriParam(label="security", secret=true)
    private String user;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="common,advanced", defaultValue="Camel")
    private String resource = "Camel";
    @UriParam(label="common", defaultValue="true")
    private boolean login = true;
    @UriParam(label="common,advanced")
    private boolean createAccount;
    @UriParam(label="common")
    private String room;
    @UriParam(label="security", secret=true)
    private String roomPassword;
    @UriParam(label="common")
    private String nickname;
    @UriParam(label="common")
    private String serviceName;
    @UriParam(label="common")
    private boolean pubsub;
    @UriParam(label="consumer")
    private boolean doc;
    @UriParam(label="common", defaultValue="true")
    private boolean testConnectionOnStartup = true;
    @UriParam(label="consumer", defaultValue="10")
    private int connectionPollDelay = 10;
    @UriParam(label="filter")
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
    @UriParam(label="advanced")
    private ConnectionConfiguration connectionConfig;

    public XmppEndpoint() {
    }

    public XmppEndpoint(String uri, XmppComponent component) {
        super(uri, (Component)component);
    }

    public String getServiceUrl() {
        return this.host + ":" + this.port;
    }

    public String getServiceProtocol() {
        return "xmpp";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.user != null) {
            return Map.of("username", this.user);
        }
        return null;
    }

    public Producer createProducer() throws Exception {
        if (this.room != null) {
            return this.createGroupChatProducer();
        }
        if (this.isPubsub()) {
            return this.createPubSubProducer();
        }
        if (this.isDoc()) {
            return this.createDirectProducer();
        }
        if (this.getParticipant() == null) {
            throw new IllegalArgumentException("No room or participant configured on this endpoint: " + this);
        }
        return this.createPrivateChatProducer(this.getParticipant());
    }

    public Producer createGroupChatProducer() {
        return new XmppGroupChatProducer(this);
    }

    public Producer createPrivateChatProducer(String participant) {
        return new XmppPrivateChatProducer(this, participant);
    }

    public Producer createDirectProducer() {
        return new XmppDirectProducer(this);
    }

    public Producer createPubSubProducer() {
        return new XmppPubSubProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        XmppConsumer answer = new XmppConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected String createEndpointUri() {
        return "xmpp://" + this.host + ":" + this.port + "/" + this.getParticipant() + "?serviceName=" + this.serviceName;
    }

    public XMPPTCPConnection createConnection() throws InterruptedException, IOException, SmackException, XMPPException {
        this.lock.lock();
        try {
            if (this.connection != null && this.connection.isConnected()) {
                XMPPTCPConnection xMPPTCPConnection = this.connection;
                return xMPPTCPConnection;
            }
            this.connection = null;
            LOG.trace("Creating new connection ...");
            XMPPTCPConnection newConnection = this.createConnectionInternal();
            newConnection.connect();
            newConnection.addSyncStanzaListener((StanzaListener)new XmppLogger("INBOUND"), stanza -> true);
            newConnection.addSyncStanzaListener((StanzaListener)new XmppLogger("OUTBOUND"), stanza -> true);
            if (!newConnection.isAuthenticated()) {
                if (this.user != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Logging in to XMPP as user: {} on connection: {}", (Object)this.user, (Object)XmppEndpoint.getConnectionMessage((XMPPConnection)newConnection));
                    }
                    if (this.password == null) {
                        LOG.warn("No password configured for user: {} on connection: {}", (Object)this.user, (Object)XmppEndpoint.getConnectionMessage((XMPPConnection)newConnection));
                    }
                    if (this.createAccount) {
                        AccountManager accountManager = AccountManager.getInstance((XMPPConnection)newConnection);
                        accountManager.createAccount(Localpart.from((String)this.user), this.password);
                    }
                    if (this.login) {
                        if (this.resource != null) {
                            newConnection.login((CharSequence)this.user, this.password, Resourcepart.from((String)this.resource));
                        } else {
                            newConnection.login((CharSequence)this.user, this.password);
                        }
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Logging in anonymously to XMPP on connection: {}", (Object)XmppEndpoint.getConnectionMessage((XMPPConnection)newConnection));
                    }
                    newConnection.login();
                }
            }
            LOG.debug("Created new connection successfully: {}", (Object)newConnection);
            XMPPTCPConnection xMPPTCPConnection = this.connection = newConnection;
            return xMPPTCPConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    private XMPPTCPConnection createConnectionInternal() throws UnknownHostException, XmppStringprepException {
        if (this.connectionConfig != null) {
            return new XMPPTCPConnection((XMPPTCPConnectionConfiguration)ObjectHelper.cast(XMPPTCPConnectionConfiguration.class, (Object)this.connectionConfig));
        }
        if (this.port == 0) {
            this.port = 5222;
        }
        String sName = this.getServiceName() == null ? this.host : this.getServiceName();
        XMPPTCPConnectionConfiguration conf = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHostAddress(InetAddress.getByName(this.host))).setPort(this.port)).setXmppDomain(sName)).build();
        return new XMPPTCPConnection(conf);
    }

    public String resolveParticipant(XMPPConnection connection) {
        String participant = this.getParticipant();
        if (participant.indexOf(64, 0) != -1) {
            return participant;
        }
        return participant + "@" + connection.getXMPPServiceDomain().toString();
    }

    public String resolveRoom(XMPPConnection connection) throws InterruptedException, SmackException, XMPPException {
        StringHelper.notEmpty((String)this.room, (String)"room");
        if (this.room.indexOf(64, 0) != -1) {
            return this.room;
        }
        MultiUserChatManager multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)connection);
        List xmppServiceDomains = multiUserChatManager.getMucServiceDomains();
        if (xmppServiceDomains.isEmpty()) {
            throw new XMPPException.XMPPErrorException(null, StanzaError.from((StanzaError.Condition)StanzaError.Condition.item_not_found, (String)("Cannot find any XMPPServiceDomain by MultiUserChatManager on connection: " + XmppEndpoint.getConnectionMessage(connection))).build());
        }
        return this.room + "@" + xmppServiceDomains.iterator().next();
    }

    public String getConnectionDescription() {
        return this.host + ":" + this.port + "/" + this.serviceName;
    }

    public static String getConnectionMessage(XMPPConnection connection) {
        return connection.getHost() + ":" + connection.getPort() + "/" + connection.getXMPPServiceDomain();
    }

    public String getChatId() {
        return "Chat:" + this.getParticipant() + ":" + this.getUser();
    }

    public XmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new XmppBinding(this.headerFilterStrategy);
        }
        return this.binding;
    }

    public void setBinding(XmppBinding binding) {
        this.binding = binding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public void setRoomPassword(String roomPassword) {
        this.roomPassword = roomPassword;
    }

    protected String getRoomPassword() {
        return this.roomPassword;
    }

    public String getParticipant() {
        return this.participant != null ? this.participant : this.user;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public String getNickname() {
        return this.nickname != null ? this.nickname : this.getUser();
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ConnectionConfiguration getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfiguration connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public boolean isTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public int getConnectionPollDelay() {
        return this.connectionPollDelay;
    }

    public void setConnectionPollDelay(int connectionPollDelay) {
        this.connectionPollDelay = connectionPollDelay;
    }

    public void setPubsub(boolean pubsub) {
        this.pubsub = pubsub;
        if (pubsub) {
            this.setDoc(true);
        }
    }

    public boolean isPubsub() {
        return this.pubsub;
    }

    public void setDoc(boolean doc) {
        this.doc = doc;
    }

    public boolean isDoc() {
        return this.doc;
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = null;
        this.binding = null;
    }
}

