/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.dataformat.xstream.AbstractXStreamWrapper;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.util.IOHelper;

@Dataformat(value="xstream")
@Metadata(includeProperties="encoding,converters,aliases,omitFields,implicitCollections,permissions,mode,contentTypeHeader")
public class XStreamDataFormat
extends AbstractXStreamWrapper {
    private String encoding;

    public XStreamDataFormat() {
    }

    public XStreamDataFormat(XStream xstream) {
        super(xstream);
    }

    public String getDataFormatName() {
        return "xstream";
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        super.marshal(exchange, body, stream);
        if (this.isContentTypeHeader()) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/xml");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
            }
        }
    }

    @Deprecated
    public static XStreamDataFormat processAnnotations(ClassResolver resolver, Iterable<Class<?>> types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream(resolver);
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    @Deprecated
    public static XStreamDataFormat processAnnotations(ClassResolver resolver, Class<?> ... types) {
        XStreamDataFormat answer = new XStreamDataFormat();
        XStream xstream = answer.getXStream(resolver);
        for (Class<?> type : types) {
            xstream.processAnnotations(type);
        }
        return answer;
    }

    protected void updateCharacterEncodingInfo(Exchange exchange) {
        if (exchange.getProperty(ExchangePropertyKey.CHARSET_NAME) == null && this.encoding != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.normalizeCharset((String)this.encoding));
        }
    }

    @Override
    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        this.updateCharacterEncodingInfo(exchange);
        if (this.getXstreamDriver() != null) {
            return this.getXstreamDriver().createWriter(stream);
        }
        XMLStreamWriter xmlWriter = (XMLStreamWriter)exchange.getContext().getTypeConverter().convertTo(XMLStreamWriter.class, exchange, (Object)stream);
        return new StaxWriter(new QNameMap(), xmlWriter);
    }

    @Override
    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        this.updateCharacterEncodingInfo(exchange);
        if (this.getXstreamDriver() != null) {
            return this.getXstreamDriver().createReader(stream);
        }
        XMLStreamReader xmlReader = (XMLStreamReader)exchange.getContext().getTypeConverter().convertTo(XMLStreamReader.class, exchange, (Object)stream);
        return new StaxReader(new QNameMap(), xmlReader);
    }
}

