/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.model.ErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.StringHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(inline=false, nodes={"error-handler", "errorHandler"}, order=0, properties={@YamlProperty(name="deadLetterChannel", type="object:org.apache.camel.model.errorhandler.DeadLetterChannelDefinition", oneOf="errorHandler"), @YamlProperty(name="defaultErrorHandler", type="object:org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition", oneOf="errorHandler"), @YamlProperty(name="jtaTransactionErrorHandler", type="object:org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition", oneOf="errorHandler"), @YamlProperty(name="noErrorHandler", type="object:org.apache.camel.model.errorhandler.NoErrorHandlerDefinition", oneOf="errorHandler"), @YamlProperty(name="refErrorHandler", type="object:org.apache.camel.model.errorhandler.RefErrorHandlerDefinition", oneOf="errorHandler"), @YamlProperty(name="springTransactionErrorHandler", type="object:org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition", oneOf="errorHandler")})
public class ErrorHandlerDeserializer
implements ConstructNode {
    private final boolean global;

    public ErrorHandlerDeserializer() {
        this(false);
    }

    public ErrorHandlerDeserializer(boolean global) {
        this.global = global;
    }

    private static CamelContextCustomizer customizer(final ErrorHandlerDefinition builder) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                camelContext.getCamelContextExtension().setErrorHandlerFactory(builder.getErrorHandlerType());
            }
        };
    }

    public Object construct(Node node) {
        MappingNode bn = YamlDeserializerSupport.asMappingNode((Node)node);
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext((Node)node);
        ErrorHandlerFactory factory = null;
        block15: for (NodeTuple tuple : bn.getValue()) {
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            YamlDeserializerSupport.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key = StringHelper.dashToCamelCase((String)key)) {
                case "deadLetterChannel": {
                    factory = (ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DeadLetterChannelDefinition.class);
                    continue block15;
                }
                case "defaultErrorHandler": {
                    factory = (ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DefaultErrorHandlerDefinition.class);
                    continue block15;
                }
                case "jtaTransactionErrorHandler": 
                case "springTransactionErrorHandler": {
                    factory = (ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, JtaTransactionErrorHandlerDefinition.class);
                    continue block15;
                }
                case "noErrorHandler": {
                    factory = (ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, NoErrorHandlerDefinition.class);
                    continue block15;
                }
                case "refErrorHandler": {
                    factory = (ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, RefErrorHandlerDefinition.class);
                    continue block15;
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        if (factory == null) {
            throw new YamlDeserializationException(node, "Unable to determine the error handler type for the node");
        }
        ErrorHandlerDefinition answer = new ErrorHandlerDefinition();
        answer.setErrorHandlerType(factory);
        if (this.global) {
            return ErrorHandlerDeserializer.customizer(answer);
        }
        return answer;
    }
}

