/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
@Configurer(extended=true)
public class ZendeskConfiguration {
    @UriPath
    @Metadata(required=true)
    private ZendeskApiMethod methodName;
    @UriParam
    private String serverUrl;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String oauthToken;
    @UriParam(label="security", secret=true)
    private String token;
    @UriParam(label="security", secret=true)
    private String password;

    public ZendeskApiMethod getMethodName() {
        return this.methodName;
    }

    public void setMethodName(ZendeskApiMethod methodName) {
        this.methodName = methodName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String token) {
        this.oauthToken = token;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object other) {
        if (other instanceof ZendeskConfiguration) {
            ZendeskConfiguration otherZendeskConf = (ZendeskConfiguration)other;
            return ObjectHelper.equal((Object)((Object)this.methodName), (Object)((Object)otherZendeskConf.getMethodName())) && ObjectHelper.equal((Object)this.serverUrl, (Object)otherZendeskConf.getServerUrl()) && ObjectHelper.equal((Object)this.username, (Object)otherZendeskConf.getUsername()) && ObjectHelper.equal((Object)this.password, (Object)otherZendeskConf.getPassword()) && ObjectHelper.equal((Object)this.token, (Object)otherZendeskConf.getToken()) && ObjectHelper.equal((Object)this.oauthToken, (Object)otherZendeskConf.getOauthToken());
        }
        return false;
    }

    public String toString() {
        return String.format("ZendeskConfiguration:[methodName=%s, serverUrl=%s, username=%s, password=%s, token=%s, oauthToken=%s]", new Object[]{this.methodName, this.serverUrl, this.username, this.password, this.token, this.oauthToken});
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

