/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.Span;
import brave.Tracing;
import brave.context.slf4j.MDCScopeDecorator;
import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Route;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinClientRequestAdapter;
import org.apache.camel.zipkin.ZipkinClientResponseAdaptor;
import org.apache.camel.zipkin.ZipkinServerRequestAdapter;
import org.apache.camel.zipkin.ZipkinServerResponseAdapter;
import org.apache.camel.zipkin.ZipkinState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.libthrift.LibthriftSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

@ManagedResource(description="ZipkinTracer")
public class ZipkinTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ZipkinTracer.class);
    private static final String ZIPKIN_COLLECTOR_HTTP_SERVICE = "zipkin-collector-http";
    private static final String ZIPKIN_COLLECTOR_THRIFT_SERVICE = "zipkin-collector-thrift";
    private static final Propagation.Getter<Message, String> GETTER = new Propagation.Getter<Message, String>(){

        public String get(Message message, String key) {
            return (String)message.getHeader(key, String.class);
        }
    };
    private static final Propagation.Setter<Message, String> SETTER = new Propagation.Setter<Message, String>(){

        public void put(Message message, String key, String value) {
            message.setHeader(key, (Object)value);
        }
    };
    private static final TraceContext.Extractor<Message> EXTRACTOR = B3Propagation.B3_STRING.extractor(GETTER);
    private static final TraceContext.Injector<Message> INJECTOR = B3Propagation.B3_STRING.injector(SETTER);
    private final ZipkinEventNotifier eventNotifier = new ZipkinEventNotifier();
    private final Map<String, Tracing> braves = new HashMap<String, Tracing>();
    private transient boolean useFallbackServiceNames;
    private CamelContext camelContext;
    private String endpoint;
    private String hostName;
    private int port;
    private float rate = 1.0f;
    private Reporter<zipkin2.Span> spanReporter;
    private Map<String, String> clientServiceMappings = new HashMap<String, String>();
    private Map<String, String> serverServiceMappings = new HashMap<String, String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private boolean includeMessageBody;
    private boolean includeMessageBodyStreams;

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
        this.init(camelContext);
        return new ZipkinRoutePolicy();
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute(description="The POST URL for zipkin's v2 api.")
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @ManagedAttribute(description="The hostname for the remote zipkin scribe collector.")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @ManagedAttribute(description="The port number for the remote zipkin scribe collector.")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ManagedAttribute(description="Rates how many events should be traced by zipkin. The rate is expressed as a percentage (1.0f = 100%, 0.5f is 50%, 0.1f is 10%).")
    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setSpanReporter(Reporter<zipkin2.Span> spanReporter) {
        this.spanReporter = spanReporter;
    }

    public Reporter<zipkin2.Span> getSpanReporter() {
        return this.spanReporter;
    }

    public String getServiceName() {
        return this.clientServiceMappings.get("*");
    }

    public void setServiceName(String serviceName) {
        this.clientServiceMappings.put("*", serviceName);
        this.serverServiceMappings.put("*", serviceName);
    }

    public Map<String, String> getClientServiceMappings() {
        return this.clientServiceMappings;
    }

    public void setClientServiceMappings(Map<String, String> clientServiceMappings) {
        this.clientServiceMappings = clientServiceMappings;
    }

    public void addClientServiceMapping(String pattern, String serviceName) {
        this.clientServiceMappings.put(pattern, serviceName);
    }

    public Map<String, String> getServerServiceMappings() {
        return this.serverServiceMappings;
    }

    public void setServerServiceMappings(Map<String, String> serverServiceMappings) {
        this.serverServiceMappings = serverServiceMappings;
    }

    public void addServerServiceMapping(String pattern, String serviceName) {
        this.serverServiceMappings.put(pattern, serviceName);
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public boolean isIncludeMessageBody() {
        return this.includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public void setIncludeMessageBody(boolean includeMessageBody) {
        this.includeMessageBody = includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public boolean isIncludeMessageBodyStreams() {
        return this.includeMessageBodyStreams;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public void setIncludeMessageBodyStreams(boolean includeMessageBodyStreams) {
        this.includeMessageBodyStreams = includeMessageBodyStreams;
    }

    protected void doStart() throws Exception {
        String serviceName;
        Set reporters;
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        if (this.spanReporter == null) {
            if (this.endpoint != null) {
                LOG.info("Configuring Zipkin URLConnectionSender using endpoint: {}", (Object)this.endpoint);
                this.spanReporter = AsyncReporter.create((Sender)URLConnectionSender.create((String)this.endpoint));
            } else if (this.hostName != null && this.port > 0) {
                LOG.info("Configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)this.hostName, (Object)this.port);
                LibthriftSender sender = LibthriftSender.newBuilder().host(this.hostName).port(this.port).build();
                this.spanReporter = AsyncReporter.create((Sender)sender);
            } else {
                int num;
                String host = new ServiceHostPropertiesFunction().apply(ZIPKIN_COLLECTOR_HTTP_SERVICE);
                String port = new ServicePortPropertiesFunction().apply(ZIPKIN_COLLECTOR_HTTP_SERVICE);
                if (ObjectHelper.isNotEmpty((Object)host) && ObjectHelper.isNotEmpty((Object)port)) {
                    LOG.info("Auto-configuring Zipkin URLConnectionSender using host: {} and port: {}", (Object)host, (Object)port);
                    num = (Integer)this.camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, (Object)port);
                    String implicitEndpoint = "http://" + host + ":" + num + "/api/v2/spans";
                    this.spanReporter = AsyncReporter.create((Sender)URLConnectionSender.create((String)implicitEndpoint));
                } else {
                    host = new ServiceHostPropertiesFunction().apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                    port = new ServicePortPropertiesFunction().apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                    if (ObjectHelper.isNotEmpty((Object)host) && ObjectHelper.isNotEmpty((Object)port)) {
                        LOG.info("Auto-configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)host, (Object)port);
                        num = (Integer)this.camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, (Object)port);
                        LibthriftSender sender = LibthriftSender.newBuilder().host(host).port(num).build();
                        this.spanReporter = AsyncReporter.create((Sender)sender);
                    }
                }
            }
        }
        if (this.spanReporter == null && (reporters = this.camelContext.getRegistry().findByType(Reporter.class)).size() == 1) {
            this.spanReporter = (Reporter)reporters.iterator().next();
        }
        ObjectHelper.notNull(this.spanReporter, (String)"Reporter<zipkin2.Span>", (Object)((Object)this));
        if (this.clientServiceMappings.isEmpty() && this.serverServiceMappings.isEmpty()) {
            LOG.warn("No service name(s) has been mapped in clientServiceMappings or serverServiceMappings. Camel will fallback and use endpoint uris as service names.");
            this.useFallbackServiceNames = true;
        }
        for (Map.Entry<String, String> entry : this.clientServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createTracingForService(pattern, serviceName);
        }
        for (Map.Entry<String, String> entry : this.serverServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createTracingForService(pattern, serviceName);
        }
        ServiceHelper.startServices((Object[])new Object[]{this.spanReporter, this.eventNotifier});
    }

    protected void doStop() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Object)((Object)this.eventNotifier));
        ServiceHelper.stopAndShutdownService(this.spanReporter);
        if (this.spanReporter instanceof Closeable) {
            IOHelper.close((Closeable)((Closeable)this.spanReporter));
        }
        this.braves.clear();
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, boolean server, boolean client) {
        if (client) {
            return this.getServiceName(exchange, endpoint, this.clientServiceMappings);
        }
        if (server) {
            return this.getServiceName(exchange, endpoint, this.serverServiceMappings);
        }
        return null;
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, Map<String, String> serviceMappings) {
        String id;
        String pattern;
        String url;
        String answer = null;
        if (endpoint != null && (url = endpoint.getEndpointUri()) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class)) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)id, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchPattern((String)id, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = exchange.getFromRouteId()) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)id, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchPattern((String)id, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && this.useFallbackServiceNames) {
            String key = null;
            if (endpoint != null) {
                key = endpoint.getEndpointKey();
            } else if (exchange.getFromEndpoint() != null) {
                key = exchange.getFromEndpoint().getEndpointKey();
            }
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)key, (String)string)) continue;
                return null;
            }
            String sanitizedKey = URISupport.sanitizeUri((String)key);
            if (LOG.isTraceEnabled() && sanitizedKey != null) {
                LOG.trace("Using serviceName: {} as fallback", (Object)sanitizedKey);
            }
            return sanitizedKey;
        }
        if (LOG.isTraceEnabled() && answer != null) {
            LOG.trace("Using serviceName: {}", answer);
        }
        return answer;
    }

    private void createTracingForService(String pattern, String serviceName) {
        Tracing brave = this.braves.get(pattern);
        if (brave == null && !this.braves.containsKey(serviceName)) {
            brave = this.newTracing(serviceName);
            this.braves.put(serviceName, brave);
        }
    }

    private Tracing newTracing(String serviceName) {
        Tracing brave = null;
        brave = this.camelContext.isUseMDCLogging() != false ? Tracing.newBuilder().currentTraceContext(ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(MDCScopeDecorator.create()).build()).localServiceName(serviceName).sampler(Sampler.create((float)this.rate)).spanReporter(this.spanReporter).build() : Tracing.newBuilder().localServiceName(serviceName).sampler(Sampler.create((float)this.rate)).spanReporter(this.spanReporter).build();
        return brave;
    }

    private Tracing getTracing(String serviceName) {
        Tracing brave = null;
        if (serviceName != null && (brave = this.braves.get(serviceName)) == null && this.useFallbackServiceNames) {
            LOG.debug("Creating Tracing assigned to serviceName: {}", (Object)(serviceName + " as fallback"));
            brave = this.newTracing(serviceName);
            this.braves.put(serviceName, brave);
        }
        return brave;
    }

    private void clientRequest(Tracing brave, String serviceName, ExchangeSendingEvent event) {
        String parentId;
        Span last;
        ZipkinState state = (ZipkinState)event.getExchange().getProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            event.getExchange().setProperty("CamelZipkinState", (Object)state);
        }
        Span span = (last = state.peekServerSpan()) != null ? brave.tracer().newChild(last.context()) : brave.tracer().nextSpan();
        span.kind(Span.Kind.CLIENT).start();
        ZipkinClientRequestAdapter parser = new ZipkinClientRequestAdapter(this, event.getEndpoint());
        INJECTOR.inject(span.context(), (Object)event.getExchange().getIn());
        parser.onRequest(event.getExchange(), span.customizer());
        state.pushClientSpan(span);
        TraceContext context = span.context();
        String traceId = "" + context.traceIdString();
        String spanId = "" + context.spanId();
        String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
        if (this.camelContext.isUseMDCLogging().booleanValue()) {
            MDC.put((String)"traceId", (String)traceId);
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)"parentId", (String)parentId);
        }
        if (LOG.isDebugEnabled()) {
            if (parentId != null) {
                LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
            } else {
                LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
            }
        }
    }

    private void clientResponse(Tracing brave, String serviceName, ExchangeSentEvent event) {
        Span span = null;
        ZipkinState state = (ZipkinState)event.getExchange().getProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popClientSpan();
        }
        if (span != null) {
            String parentId;
            ZipkinClientResponseAdaptor parser = new ZipkinClientResponseAdaptor(this, event.getEndpoint());
            parser.onResponse(event.getExchange(), span.customizer());
            span.finish();
            TraceContext context = span.context();
            String traceId = "" + context.traceIdString();
            String spanId = "" + context.spanId();
            String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
            if (this.camelContext.isUseMDCLogging().booleanValue()) {
                MDC.put((String)"traceId", (String)traceId);
                MDC.put((String)"spanId", (String)spanId);
                MDC.put((String)"parentId", (String)parentId);
            }
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
    }

    private Span serverRequest(Tracing brave, String serviceName, Exchange exchange) {
        String parentId;
        ZipkinState state = (ZipkinState)exchange.getProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            exchange.setProperty("CamelZipkinState", (Object)state);
        }
        Span span = null;
        TraceContextOrSamplingFlags sampleFlag = EXTRACTOR.extract((Object)exchange.getIn());
        if (ObjectHelper.isEmpty((Object)sampleFlag)) {
            span = brave.tracer().nextSpan();
            INJECTOR.inject(span.context(), (Object)exchange.getIn());
        } else {
            span = brave.tracer().nextSpan(sampleFlag);
        }
        span.kind(Span.Kind.SERVER).start();
        ZipkinServerRequestAdapter parser = new ZipkinServerRequestAdapter(this, exchange);
        parser.onRequest(exchange, span.customizer());
        state.pushServerSpan(span);
        TraceContext context = span.context();
        String traceId = "" + context.traceIdString();
        String spanId = "" + context.spanId();
        String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
        if (this.camelContext.isUseMDCLogging().booleanValue()) {
            MDC.put((String)"traceId", (String)traceId);
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)"parentId", (String)parentId);
        }
        if (LOG.isDebugEnabled()) {
            if (parentId != null) {
                LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
            } else {
                LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
            }
        }
        return span;
    }

    private void serverResponse(Tracing brave, String serviceName, Exchange exchange) {
        Span span = null;
        ZipkinState state = (ZipkinState)exchange.getProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popServerSpan();
        }
        if (span != null) {
            String parentId;
            ZipkinServerResponseAdapter parser = new ZipkinServerResponseAdapter(this, exchange);
            parser.onResponse(exchange, span.customizer());
            span.finish();
            TraceContext context = span.context();
            String traceId = "" + context.traceIdString();
            String spanId = "" + context.spanId();
            String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
            if (this.camelContext.isUseMDCLogging().booleanValue()) {
                MDC.put((String)"traceId", (String)traceId);
                MDC.put((String)"spanId", (String)spanId);
                MDC.put((String)"parentId", (String)parentId);
            }
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
    }

    private final class ZipkinRoutePolicy
    extends RoutePolicySupport {
        private ZipkinRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            String serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false);
            Tracing brave = ZipkinTracer.this.getTracing(serviceName);
            if (brave != null) {
                ZipkinTracer.this.serverRequest(brave, serviceName, exchange);
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            String serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false);
            Tracing brave = ZipkinTracer.this.getTracing(serviceName);
            if (brave != null) {
                ZipkinTracer.this.serverResponse(brave, serviceName, exchange);
            }
        }
    }

    private final class ZipkinEventNotifier
    extends EventNotifierSupport {
        private ZipkinEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            ExchangeSentEvent ese;
            String serviceName;
            Tracing brave;
            if (event instanceof ExchangeSendingEvent) {
                ExchangeSendingEvent ese2 = (ExchangeSendingEvent)event;
                String serviceName2 = ZipkinTracer.this.getServiceName(ese2.getExchange(), ese2.getEndpoint(), false, true);
                Tracing brave2 = ZipkinTracer.this.getTracing(serviceName2);
                if (brave2 != null) {
                    ZipkinTracer.this.clientRequest(brave2, serviceName2, ese2);
                }
            } else if (event instanceof ExchangeSentEvent && (brave = ZipkinTracer.this.getTracing(serviceName = ZipkinTracer.this.getServiceName((ese = (ExchangeSentEvent)event).getExchange(), ese.getEndpoint(), false, true))) != null) {
                ZipkinTracer.this.clientResponse(brave, serviceName, ese);
            }
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent || event instanceof ExchangeCreatedEvent || event instanceof ExchangeCompletedEvent || event instanceof ExchangeFailedEvent;
        }

        public String toString() {
            return "ZipkinEventNotifier";
        }
    }
}

