/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.StatefulService;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.spi.UuidGenerator;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorMultiMasterLeaderElection
implements ConnectionStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorMultiMasterLeaderElection.class);
    private final String candidateName;
    private final List<ElectionWatcher> watchers = new ArrayList<ElectionWatcher>();
    private final int desiredActiveNodes;
    private AtomicBoolean activeNode = new AtomicBoolean(false);
    private UuidGenerator uuidGenerator = new JavaUuidGenerator();
    private InterProcessSemaphoreV2 leaderSelector;
    private CuratorFramework client;
    private Lease lease;

    public CuratorMultiMasterLeaderElection(String uri, int desiredActiveNodes) {
        this.candidateName = this.createCandidateName();
        this.desiredActiveNodes = desiredActiveNodes;
        String connectionString = uri.substring(1 + uri.indexOf(58)).split("/")[0];
        String protocol = uri.substring(0, uri.indexOf(58));
        String path = uri.replace(protocol + ":" + connectionString, "");
        this.client = CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.client.getConnectionStateListenable().addListener((Object)this);
        this.leaderSelector = new InterProcessSemaphoreV2(this.client, path, this.desiredActiveNodes);
        this.client.start();
    }

    public static boolean isCamelStopping(CamelContext context) {
        if (context instanceof StatefulService) {
            StatefulService ss = (StatefulService)context;
            return ss.isStopping() || ss.isStopped();
        }
        return false;
    }

    public void shutdownClients() {
        try {
            this.leaderSelector.returnLease(this.lease);
        }
        finally {
            this.client.close();
        }
    }

    public void requestResource() {
        LOG.info("Requested to become active from {}", (Object)this.candidateName);
        try {
            this.lease = this.leaderSelector.acquire();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain access to become a leader node.");
        }
        LOG.info("{} is now active", (Object)this.candidateName);
        this.activeNode.set(true);
        this.notifyElectionWatchers();
    }

    public boolean isMaster() {
        return this.activeNode.get();
    }

    private String createCandidateName() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException ex) {
            LOG.warn("Failed to get the local hostname.", (Throwable)ex);
            builder.append("unknown-host");
        }
        builder.append("-").append(this.uuidGenerator.generateUuid());
        return builder.toString();
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    private void notifyElectionWatchers() {
        for (ElectionWatcher watcher : this.watchers) {
            try {
                watcher.electionResultChanged();
            }
            catch (Exception e) {
                LOG.warn("Election watcher " + watcher + " of type " + watcher.getClass() + " threw an exception.", (Throwable)e);
            }
        }
    }

    public boolean addElectionWatcher(ElectionWatcher e) {
        return this.watchers.add(e);
    }

    public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
        switch (connectionState) {
            case SUSPENDED: 
            case LOST: {
                LOG.info("Received {} state from connection. Giving up lock.", (Object)connectionState);
                try {
                    this.leaderSelector.returnLease(this.lease);
                    break;
                }
                finally {
                    this.activeNode.set(false);
                    this.notifyElectionWatchers();
                }
            }
            default: {
                LOG.info("Connection state changed: {}", (Object)connectionState);
                this.requestResource();
            }
        }
    }
}

