/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.concurrent.CountDownLatch;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHolder
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionHolder.class);
    private CountDownLatch connectionLatch = new CountDownLatch(1);
    private ZooKeeperConfiguration configuration;
    private ZooKeeper zookeeper;

    public ConnectionHolder(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    public ZooKeeper getZooKeeper() {
        if (this.zookeeper != null) {
            return this.zookeeper;
        }
        if (this.configuration.getConnectString() == null) {
            throw new RuntimeCamelException("Cannot create ZooKeeper connection as connection string is null. Have servers been configured?");
        }
        try {
            this.zookeeper = new ZooKeeper(this.configuration.getConnectString(), this.configuration.getTimeout(), (Watcher)this);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        this.awaitConnection();
        return this.zookeeper;
    }

    public boolean isConnected() {
        return this.connectionLatch.getCount() == 0L;
    }

    public void awaitConnection() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Awaiting Connection event from Zookeeper cluster {}", (Object)this.configuration.getConnectString());
        }
        try {
            this.connectionLatch.await();
        }
        catch (InterruptedException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.connectionLatch.countDown();
        }
        this.connectionLatch.countDown();
    }

    public void closeConnection() {
        try {
            if (this.zookeeper != null) {
                this.zookeeper.close();
                this.zookeeper = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutting down connection to Zookeeper cluster {}", (Object)this.configuration.getConnectString());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Error closing zookeeper connection {}. This exception will be ignored.", (Object)this.configuration.getConnectString(), (Object)e);
        }
    }
}

