/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class OperationResult<ResultType> {
    private Stat statistics;
    private ResultType result;
    private Exception exception;
    private boolean ok;

    public OperationResult(ResultType result, Stat statistics) {
        this(result, statistics, true);
    }

    public OperationResult(ResultType result, Stat statistics, boolean ok) {
        this.result = result;
        this.statistics = statistics;
        this.ok = ok;
    }

    public OperationResult(Exception exception) {
        this.exception = exception;
        this.ok = false;
    }

    public Exception getException() {
        return this.exception;
    }

    public Stat getStatistics() {
        return this.statistics;
    }

    public ResultType getResult() {
        return this.result;
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean failedDueTo(KeeperException.Code ... codes) {
        if (this.exception instanceof KeeperException) {
            for (KeeperException.Code code : codes) {
                if (!code.equals((Object)((KeeperException)this.exception).code())) continue;
                return true;
            }
        }
        return false;
    }
}

