/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationkitspec.Configuration;
import org.apache.camel.v1.integrationkitspec.Sources;
import org.apache.camel.v1.integrationkitspec.Traits;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "dependencies", "image", "profile", "repositories", "sources", "traits"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationKitSpec
implements KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Deprecated: Use camel trait (camel.properties) to manage properties Use mount trait (mount.configs) to manage configs Use mount trait (mount.resources) to manage resources Use mount trait (mount.volumes) to manage volumes configuration used by the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Configuration> configuration;
    @JsonProperty(value="dependencies")
    @JsonPropertyDescription(value="a list of Camel dependecies used by this kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> dependencies;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="the container image as identified in the container registry")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="the profile which is expected by this kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String profile;
    @JsonProperty(value="repositories")
    @JsonPropertyDescription(value="Maven repositories that can be used by the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> repositories;
    @JsonProperty(value="sources")
    @JsonPropertyDescription(value="the sources to add at build time")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sources> sources;
    @JsonProperty(value="traits")
    @JsonPropertyDescription(value="traits that the kit will execute")
    @JsonSetter(nulls=Nulls.SKIP)
    private Traits traits;

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<Configuration> configuration) {
        this.configuration = configuration;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public List<Sources> getSources() {
        return this.sources;
    }

    public void setSources(List<Sources> sources) {
        this.sources = sources;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public void setTraits(Traits traits) {
        this.traits = traits;
    }

    public String toString() {
        return "IntegrationKitSpec(configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", image=" + this.getImage() + ", profile=" + this.getProfile() + ", repositories=" + this.getRepositories() + ", sources=" + this.getSources() + ", traits=" + this.getTraits() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationKitSpec)) {
            return false;
        }
        IntegrationKitSpec other = (IntegrationKitSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Configuration> this$configuration = this.getConfiguration();
        List<Configuration> other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$repositories = this.getRepositories();
        List<String> other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories)) {
            return false;
        }
        List<Sources> this$sources = this.getSources();
        List<Sources> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        Traits this$traits = this.getTraits();
        Traits other$traits = other.getTraits();
        return !(this$traits == null ? other$traits != null : !((Object)this$traits).equals(other$traits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegrationKitSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Configuration> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        List<Sources> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        Traits $traits = this.getTraits();
        result = result * 59 + ($traits == null ? 43 : ((Object)$traits).hashCode());
        return result;
    }
}

