/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.camelcatalogspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.camelcatalogspec.Artifacts;
import org.apache.camel.v1.camelcatalogspec.artifacts.Dependencies;
import org.apache.camel.v1.camelcatalogspec.artifacts.DependenciesBuilder;
import org.apache.camel.v1.camelcatalogspec.artifacts.DependenciesFluent;
import org.apache.camel.v1.camelcatalogspec.artifacts.Exclusions;
import org.apache.camel.v1.camelcatalogspec.artifacts.ExclusionsBuilder;
import org.apache.camel.v1.camelcatalogspec.artifacts.ExclusionsFluent;
import org.apache.camel.v1.camelcatalogspec.artifacts.Schemes;
import org.apache.camel.v1.camelcatalogspec.artifacts.SchemesBuilder;
import org.apache.camel.v1.camelcatalogspec.artifacts.SchemesFluent;

public class ArtifactsFluent<A extends ArtifactsFluent<A>>
extends BaseFluent<A> {
    private String artifactId;
    private List<String> dataformats;
    private ArrayList<DependenciesBuilder> dependencies;
    private ArrayList<ExclusionsBuilder> exclusions;
    private String groupId;
    private List<String> javaTypes;
    private List<String> languages;
    private ArrayList<SchemesBuilder> schemes;
    private String version;

    public ArtifactsFluent() {
    }

    public ArtifactsFluent(Artifacts instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Artifacts instance) {
        Artifacts artifacts = instance = instance != null ? instance : new Artifacts();
        if (instance != null) {
            this.withArtifactId(instance.getArtifactId());
            this.withDataformats(instance.getDataformats());
            this.withDependencies(instance.getDependencies());
            this.withExclusions(instance.getExclusions());
            this.withGroupId(instance.getGroupId());
            this.withJavaTypes(instance.getJavaTypes());
            this.withLanguages(instance.getLanguages());
            this.withSchemes(instance.getSchemes());
            this.withVersion(instance.getVersion());
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (A)((Object)this);
    }

    public boolean hasArtifactId() {
        return this.artifactId != null;
    }

    public A addToDataformats(int index, String item) {
        if (this.dataformats == null) {
            this.dataformats = new ArrayList<String>();
        }
        this.dataformats.add(index, item);
        return (A)((Object)this);
    }

    public A setToDataformats(int index, String item) {
        if (this.dataformats == null) {
            this.dataformats = new ArrayList<String>();
        }
        this.dataformats.set(index, item);
        return (A)((Object)this);
    }

    public A addToDataformats(String ... items) {
        if (this.dataformats == null) {
            this.dataformats = new ArrayList<String>();
        }
        for (String item : items) {
            this.dataformats.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDataformats(Collection<String> items) {
        if (this.dataformats == null) {
            this.dataformats = new ArrayList<String>();
        }
        for (String item : items) {
            this.dataformats.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDataformats(String ... items) {
        if (this.dataformats == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dataformats.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDataformats(Collection<String> items) {
        if (this.dataformats == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dataformats.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDataformats() {
        return this.dataformats;
    }

    public String getDataformat(int index) {
        return this.dataformats.get(index);
    }

    public String getFirstDataformat() {
        return this.dataformats.get(0);
    }

    public String getLastDataformat() {
        return this.dataformats.get(this.dataformats.size() - 1);
    }

    public String getMatchingDataformat(Predicate<String> predicate) {
        for (String item : this.dataformats) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDataformat(Predicate<String> predicate) {
        for (String item : this.dataformats) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataformats(List<String> dataformats) {
        if (dataformats != null) {
            this.dataformats = new ArrayList<String>();
            for (String item : dataformats) {
                this.addToDataformats(item);
            }
        } else {
            this.dataformats = null;
        }
        return (A)((Object)this);
    }

    public A withDataformats(String ... dataformats) {
        if (this.dataformats != null) {
            this.dataformats.clear();
            this._visitables.remove((Object)"dataformats");
        }
        if (dataformats != null) {
            for (String item : dataformats) {
                this.addToDataformats(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDataformats() {
        return this.dataformats != null && !this.dataformats.isEmpty();
    }

    public A addToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToArtifactsDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArtifactsDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromArtifactsDependencies(Predicate<DependenciesBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        Iterator<DependenciesBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            DependenciesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Dependencies> buildDependencies() {
        return this.dependencies != null ? ArtifactsFluent.build(this.dependencies) : null;
    }

    public Dependencies buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public Dependencies buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public Dependencies buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    public Dependencies buildMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<Dependencies> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").clear();
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList();
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(Dependencies ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public DependenciesNested<A> addNewDependency() {
        return new DependenciesNested(-1, null);
    }

    public DependenciesNested<A> addNewDependencyLike(Dependencies item) {
        return new DependenciesNested(-1, item);
    }

    public DependenciesNested<A> setNewDependencyLike(int index, Dependencies item) {
        return new DependenciesNested(index, item);
    }

    public DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    public DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public A addToExclusions(int index, Exclusions item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        ExclusionsBuilder builder = new ExclusionsBuilder(item);
        if (index < 0 || index >= this.exclusions.size()) {
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        } else {
            this._visitables.get((Object)"exclusions").add(index, builder);
            this.exclusions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExclusions(int index, Exclusions item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        ExclusionsBuilder builder = new ExclusionsBuilder(item);
        if (index < 0 || index >= this.exclusions.size()) {
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        } else {
            this._visitables.get((Object)"exclusions").set(index, builder);
            this.exclusions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExclusions(Exclusions ... items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExclusions(Collection<Exclusions> items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExclusions(Exclusions ... items) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").remove((Object)builder);
            this.exclusions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExclusions(Collection<Exclusions> items) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").remove((Object)builder);
            this.exclusions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExclusions(Predicate<ExclusionsBuilder> predicate) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        Iterator<ExclusionsBuilder> each = this.exclusions.iterator();
        List visitables = this._visitables.get((Object)"exclusions");
        while (each.hasNext()) {
            ExclusionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Exclusions> buildExclusions() {
        return this.exclusions != null ? ArtifactsFluent.build(this.exclusions) : null;
    }

    public Exclusions buildExclusion(int index) {
        return this.exclusions.get(index).build();
    }

    public Exclusions buildFirstExclusion() {
        return this.exclusions.get(0).build();
    }

    public Exclusions buildLastExclusion() {
        return this.exclusions.get(this.exclusions.size() - 1).build();
    }

    public Exclusions buildMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        for (ExclusionsBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        for (ExclusionsBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExclusions(List<Exclusions> exclusions) {
        if (this.exclusions != null) {
            this._visitables.get((Object)"exclusions").clear();
        }
        if (exclusions != null) {
            this.exclusions = new ArrayList();
            for (Exclusions item : exclusions) {
                this.addToExclusions(item);
            }
        } else {
            this.exclusions = null;
        }
        return (A)((Object)this);
    }

    public A withExclusions(Exclusions ... exclusions) {
        if (this.exclusions != null) {
            this.exclusions.clear();
            this._visitables.remove((Object)"exclusions");
        }
        if (exclusions != null) {
            for (Exclusions item : exclusions) {
                this.addToExclusions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExclusions() {
        return this.exclusions != null && !this.exclusions.isEmpty();
    }

    public ExclusionsNested<A> addNewExclusion() {
        return new ExclusionsNested(-1, null);
    }

    public ExclusionsNested<A> addNewExclusionLike(Exclusions item) {
        return new ExclusionsNested(-1, item);
    }

    public ExclusionsNested<A> setNewExclusionLike(int index, Exclusions item) {
        return new ExclusionsNested(index, item);
    }

    public ExclusionsNested<A> editExclusion(int index) {
        if (this.exclusions.size() <= index) {
            throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public ExclusionsNested<A> editFirstExclusion() {
        if (this.exclusions.size() == 0) {
            throw new RuntimeException("Can't edit first exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(0, this.buildExclusion(0));
    }

    public ExclusionsNested<A> editLastExclusion() {
        int index = this.exclusions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public ExclusionsNested<A> editMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!predicate.test(this.exclusions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching exclusions. No match found.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId = groupId;
        return (A)((Object)this);
    }

    public boolean hasGroupId() {
        return this.groupId != null;
    }

    public A addToJavaTypes(int index, String item) {
        if (this.javaTypes == null) {
            this.javaTypes = new ArrayList<String>();
        }
        this.javaTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToJavaTypes(int index, String item) {
        if (this.javaTypes == null) {
            this.javaTypes = new ArrayList<String>();
        }
        this.javaTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToJavaTypes(String ... items) {
        if (this.javaTypes == null) {
            this.javaTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.javaTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToJavaTypes(Collection<String> items) {
        if (this.javaTypes == null) {
            this.javaTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.javaTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromJavaTypes(String ... items) {
        if (this.javaTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.javaTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJavaTypes(Collection<String> items) {
        if (this.javaTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.javaTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getJavaTypes() {
        return this.javaTypes;
    }

    public String getJavaType(int index) {
        return this.javaTypes.get(index);
    }

    public String getFirstJavaType() {
        return this.javaTypes.get(0);
    }

    public String getLastJavaType() {
        return this.javaTypes.get(this.javaTypes.size() - 1);
    }

    public String getMatchingJavaType(Predicate<String> predicate) {
        for (String item : this.javaTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingJavaType(Predicate<String> predicate) {
        for (String item : this.javaTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJavaTypes(List<String> javaTypes) {
        if (javaTypes != null) {
            this.javaTypes = new ArrayList<String>();
            for (String item : javaTypes) {
                this.addToJavaTypes(item);
            }
        } else {
            this.javaTypes = null;
        }
        return (A)((Object)this);
    }

    public A withJavaTypes(String ... javaTypes) {
        if (this.javaTypes != null) {
            this.javaTypes.clear();
            this._visitables.remove((Object)"javaTypes");
        }
        if (javaTypes != null) {
            for (String item : javaTypes) {
                this.addToJavaTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJavaTypes() {
        return this.javaTypes != null && !this.javaTypes.isEmpty();
    }

    public A addToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(index, item);
        return (A)((Object)this);
    }

    public A setToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.set(index, item);
        return (A)((Object)this);
    }

    public A addToLanguages(String ... items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLanguages(Collection<String> items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLanguages(String ... items) {
        if (this.languages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.languages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLanguages(Collection<String> items) {
        if (this.languages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.languages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    public String getFirstLanguage() {
        return this.languages.get(0);
    }

    public String getLastLanguage() {
        return this.languages.get(this.languages.size() - 1);
    }

    public String getMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLanguages(List<String> languages) {
        if (languages != null) {
            this.languages = new ArrayList<String>();
            for (String item : languages) {
                this.addToLanguages(item);
            }
        } else {
            this.languages = null;
        }
        return (A)((Object)this);
    }

    public A withLanguages(String ... languages) {
        if (this.languages != null) {
            this.languages.clear();
            this._visitables.remove((Object)"languages");
        }
        if (languages != null) {
            for (String item : languages) {
                this.addToLanguages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLanguages() {
        return this.languages != null && !this.languages.isEmpty();
    }

    public A addToSchemes(int index, Schemes item) {
        if (this.schemes == null) {
            this.schemes = new ArrayList();
        }
        SchemesBuilder builder = new SchemesBuilder(item);
        if (index < 0 || index >= this.schemes.size()) {
            this._visitables.get((Object)"schemes").add(builder);
            this.schemes.add(builder);
        } else {
            this._visitables.get((Object)"schemes").add(index, builder);
            this.schemes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSchemes(int index, Schemes item) {
        if (this.schemes == null) {
            this.schemes = new ArrayList();
        }
        SchemesBuilder builder = new SchemesBuilder(item);
        if (index < 0 || index >= this.schemes.size()) {
            this._visitables.get((Object)"schemes").add(builder);
            this.schemes.add(builder);
        } else {
            this._visitables.get((Object)"schemes").set(index, builder);
            this.schemes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSchemes(Schemes ... items) {
        if (this.schemes == null) {
            this.schemes = new ArrayList();
        }
        for (Schemes item : items) {
            SchemesBuilder builder = new SchemesBuilder(item);
            this._visitables.get((Object)"schemes").add(builder);
            this.schemes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSchemes(Collection<Schemes> items) {
        if (this.schemes == null) {
            this.schemes = new ArrayList();
        }
        for (Schemes item : items) {
            SchemesBuilder builder = new SchemesBuilder(item);
            this._visitables.get((Object)"schemes").add(builder);
            this.schemes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSchemes(Schemes ... items) {
        if (this.schemes == null) {
            return (A)((Object)this);
        }
        for (Schemes item : items) {
            SchemesBuilder builder = new SchemesBuilder(item);
            this._visitables.get((Object)"schemes").remove((Object)builder);
            this.schemes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSchemes(Collection<Schemes> items) {
        if (this.schemes == null) {
            return (A)((Object)this);
        }
        for (Schemes item : items) {
            SchemesBuilder builder = new SchemesBuilder(item);
            this._visitables.get((Object)"schemes").remove((Object)builder);
            this.schemes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSchemes(Predicate<SchemesBuilder> predicate) {
        if (this.schemes == null) {
            return (A)((Object)this);
        }
        Iterator<SchemesBuilder> each = this.schemes.iterator();
        List visitables = this._visitables.get((Object)"schemes");
        while (each.hasNext()) {
            SchemesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Schemes> buildSchemes() {
        return this.schemes != null ? ArtifactsFluent.build(this.schemes) : null;
    }

    public Schemes buildScheme(int index) {
        return this.schemes.get(index).build();
    }

    public Schemes buildFirstScheme() {
        return this.schemes.get(0).build();
    }

    public Schemes buildLastScheme() {
        return this.schemes.get(this.schemes.size() - 1).build();
    }

    public Schemes buildMatchingScheme(Predicate<SchemesBuilder> predicate) {
        for (SchemesBuilder item : this.schemes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingScheme(Predicate<SchemesBuilder> predicate) {
        for (SchemesBuilder item : this.schemes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSchemes(List<Schemes> schemes) {
        if (this.schemes != null) {
            this._visitables.get((Object)"schemes").clear();
        }
        if (schemes != null) {
            this.schemes = new ArrayList();
            for (Schemes item : schemes) {
                this.addToSchemes(item);
            }
        } else {
            this.schemes = null;
        }
        return (A)((Object)this);
    }

    public A withSchemes(Schemes ... schemes) {
        if (this.schemes != null) {
            this.schemes.clear();
            this._visitables.remove((Object)"schemes");
        }
        if (schemes != null) {
            for (Schemes item : schemes) {
                this.addToSchemes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSchemes() {
        return this.schemes != null && !this.schemes.isEmpty();
    }

    public SchemesNested<A> addNewScheme() {
        return new SchemesNested(-1, null);
    }

    public SchemesNested<A> addNewSchemeLike(Schemes item) {
        return new SchemesNested(-1, item);
    }

    public SchemesNested<A> setNewSchemeLike(int index, Schemes item) {
        return new SchemesNested(index, item);
    }

    public SchemesNested<A> editScheme(int index) {
        if (this.schemes.size() <= index) {
            throw new RuntimeException("Can't edit schemes. Index exceeds size.");
        }
        return this.setNewSchemeLike(index, this.buildScheme(index));
    }

    public SchemesNested<A> editFirstScheme() {
        if (this.schemes.size() == 0) {
            throw new RuntimeException("Can't edit first schemes. The list is empty.");
        }
        return this.setNewSchemeLike(0, this.buildScheme(0));
    }

    public SchemesNested<A> editLastScheme() {
        int index = this.schemes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last schemes. The list is empty.");
        }
        return this.setNewSchemeLike(index, this.buildScheme(index));
    }

    public SchemesNested<A> editMatchingScheme(Predicate<SchemesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.schemes.size(); ++i) {
            if (!predicate.test(this.schemes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching schemes. No match found.");
        }
        return this.setNewSchemeLike(index, this.buildScheme(index));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArtifactsFluent that = (ArtifactsFluent)((Object)o);
        if (!Objects.equals(this.artifactId, that.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.dataformats, that.dataformats)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.exclusions, that.exclusions)) {
            return false;
        }
        if (!Objects.equals(this.groupId, that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.javaTypes, that.javaTypes)) {
            return false;
        }
        if (!Objects.equals(this.languages, that.languages)) {
            return false;
        }
        if (!Objects.equals(this.schemes, that.schemes)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.dataformats, this.dependencies, this.exclusions, this.groupId, this.javaTypes, this.languages, this.schemes, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifactId != null) {
            sb.append("artifactId:");
            sb.append(this.artifactId + ",");
        }
        if (this.dataformats != null && !this.dataformats.isEmpty()) {
            sb.append("dataformats:");
            sb.append(this.dataformats + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.exclusions != null && !this.exclusions.isEmpty()) {
            sb.append("exclusions:");
            sb.append(this.exclusions + ",");
        }
        if (this.groupId != null) {
            sb.append("groupId:");
            sb.append(this.groupId + ",");
        }
        if (this.javaTypes != null && !this.javaTypes.isEmpty()) {
            sb.append("javaTypes:");
            sb.append(this.javaTypes + ",");
        }
        if (this.languages != null && !this.languages.isEmpty()) {
            sb.append("languages:");
            sb.append(this.languages + ",");
        }
        if (this.schemes != null && !this.schemes.isEmpty()) {
            sb.append("schemes:");
            sb.append(this.schemes + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DependenciesNested<N>
    extends DependenciesFluent<DependenciesNested<N>>
    implements Nested<N> {
        DependenciesBuilder builder;
        int index;

        DependenciesNested(int index, Dependencies item) {
            this.index = index;
            this.builder = new DependenciesBuilder(this, item);
        }

        public N and() {
            return (N)ArtifactsFluent.this.setToDependencies(this.index, this.builder.build());
        }

        public N endArtifactsDependency() {
            return this.and();
        }
    }

    public class ExclusionsNested<N>
    extends ExclusionsFluent<ExclusionsNested<N>>
    implements Nested<N> {
        ExclusionsBuilder builder;
        int index;

        ExclusionsNested(int index, Exclusions item) {
            this.index = index;
            this.builder = new ExclusionsBuilder(this, item);
        }

        public N and() {
            return (N)ArtifactsFluent.this.setToExclusions(this.index, this.builder.build());
        }

        public N endExclusion() {
            return this.and();
        }
    }

    public class SchemesNested<N>
    extends SchemesFluent<SchemesNested<N>>
    implements Nested<N> {
        SchemesBuilder builder;
        int index;

        SchemesNested(int index, Schemes item) {
            this.index = index;
            this.builder = new SchemesBuilder(this, item);
        }

        public N and() {
            return (N)ArtifactsFluent.this.setToSchemes(this.index, this.builder.build());
        }

        public N endScheme() {
            return this.and();
        }
    }
}

