/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationplatformspec.traits.service.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"auto", "configuration", "enabled", "nodePort", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Service
implements KubernetesResource {
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="To automatically detect from the code if a Service needs to be created.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="nodePort")
    @JsonPropertyDescription(value="Enable Service to be exposed as NodePort (default `false`). Deprecated: Use service type instead.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean nodePort = false;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of service to be used, either 'ClusterIP', 'NodePort' or 'LoadBalancer'.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Type type;

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(Boolean nodePort) {
        this.nodePort = nodePort;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "Service(auto=" + this.getAuto() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", nodePort=" + this.getNodePort() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service other = (Service)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$nodePort = this.getNodePort();
        Boolean other$nodePort = other.getNodePort();
        if (this$nodePort == null ? other$nodePort != null : !((Object)this$nodePort).equals(other$nodePort)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Service;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $nodePort = this.getNodePort();
        result = result * 59 + ($nodePort == null ? 43 : ((Object)$nodePort).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum Type {
        CLUSTERIP("ClusterIP"),
        NODEPORT("NodePort"),
        LOADBALANCER("LoadBalancer");

        String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

