/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.traits.container.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"auto", "configuration", "enabled", "expose", "image", "imagePullPolicy", "limitCPU", "limitMemory", "name", "port", "portName", "requestCPU", "requestMemory", "servicePort", "servicePortName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Container
implements KubernetesResource {
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="To automatically enable the trait")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="expose")
    @JsonPropertyDescription(value="Can be used to enable/disable exposure via kubernetes Service.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean expose;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="The main container image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="imagePullPolicy")
    @JsonPropertyDescription(value="The pull policy: Always|Never|IfNotPresent")
    @JsonSetter(nulls=Nulls.SKIP)
    private ImagePullPolicy imagePullPolicy;
    @JsonProperty(value="limitCPU")
    @JsonPropertyDescription(value="The maximum amount of CPU required.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitCPU;
    @JsonProperty(value="limitMemory")
    @JsonPropertyDescription(value="The maximum amount of memory required.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitMemory;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The main container name. It's named `integration` by default.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name = "integration";
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="To configure a different port exposed by the container (default `8080`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long port = 8080L;
    @JsonProperty(value="portName")
    @JsonPropertyDescription(value="To configure a different port name for the port exposed by the container. It defaults to `http` only when the `expose` parameter is true.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String portName;
    @JsonProperty(value="requestCPU")
    @JsonPropertyDescription(value="The minimum amount of CPU required.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestCPU;
    @JsonProperty(value="requestMemory")
    @JsonPropertyDescription(value="The minimum amount of memory required.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestMemory;
    @JsonProperty(value="servicePort")
    @JsonPropertyDescription(value="To configure under which service port the container port is to be exposed (default `80`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long servicePort = 80L;
    @JsonProperty(value="servicePortName")
    @JsonPropertyDescription(value="To configure under which service port name the container port is to be exposed (default `http`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String servicePortName = "http";

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public void setExpose(Boolean expose) {
        this.expose = expose;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public void setLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public void setRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    public Long getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(Long servicePort) {
        this.servicePort = servicePort;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public String toString() {
        return "Container(auto=" + this.getAuto() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", expose=" + this.getExpose() + ", image=" + this.getImage() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", limitCPU=" + this.getLimitCPU() + ", limitMemory=" + this.getLimitMemory() + ", name=" + this.getName() + ", port=" + this.getPort() + ", portName=" + this.getPortName() + ", requestCPU=" + this.getRequestCPU() + ", requestMemory=" + this.getRequestMemory() + ", servicePort=" + this.getServicePort() + ", servicePortName=" + this.getServicePortName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$expose = this.getExpose();
        Boolean other$expose = other.getExpose();
        if (this$expose == null ? other$expose != null : !((Object)this$expose).equals(other$expose)) {
            return false;
        }
        Long this$port = this.getPort();
        Long other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$servicePort = this.getServicePort();
        Long other$servicePort = other.getServicePort();
        if (this$servicePort == null ? other$servicePort != null : !((Object)this$servicePort).equals(other$servicePort)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        ImagePullPolicy this$imagePullPolicy = this.getImagePullPolicy();
        ImagePullPolicy other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !((Object)((Object)this$imagePullPolicy)).equals((Object)other$imagePullPolicy)) {
            return false;
        }
        String this$limitCPU = this.getLimitCPU();
        String other$limitCPU = other.getLimitCPU();
        if (this$limitCPU == null ? other$limitCPU != null : !this$limitCPU.equals(other$limitCPU)) {
            return false;
        }
        String this$limitMemory = this.getLimitMemory();
        String other$limitMemory = other.getLimitMemory();
        if (this$limitMemory == null ? other$limitMemory != null : !this$limitMemory.equals(other$limitMemory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$portName = this.getPortName();
        String other$portName = other.getPortName();
        if (this$portName == null ? other$portName != null : !this$portName.equals(other$portName)) {
            return false;
        }
        String this$requestCPU = this.getRequestCPU();
        String other$requestCPU = other.getRequestCPU();
        if (this$requestCPU == null ? other$requestCPU != null : !this$requestCPU.equals(other$requestCPU)) {
            return false;
        }
        String this$requestMemory = this.getRequestMemory();
        String other$requestMemory = other.getRequestMemory();
        if (this$requestMemory == null ? other$requestMemory != null : !this$requestMemory.equals(other$requestMemory)) {
            return false;
        }
        String this$servicePortName = this.getServicePortName();
        String other$servicePortName = other.getServicePortName();
        return !(this$servicePortName == null ? other$servicePortName != null : !this$servicePortName.equals(other$servicePortName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $expose = this.getExpose();
        result = result * 59 + ($expose == null ? 43 : ((Object)$expose).hashCode());
        Long $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $servicePort = this.getServicePort();
        result = result * 59 + ($servicePort == null ? 43 : ((Object)$servicePort).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        ImagePullPolicy $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : ((Object)((Object)$imagePullPolicy)).hashCode());
        String $limitCPU = this.getLimitCPU();
        result = result * 59 + ($limitCPU == null ? 43 : $limitCPU.hashCode());
        String $limitMemory = this.getLimitMemory();
        result = result * 59 + ($limitMemory == null ? 43 : $limitMemory.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $portName = this.getPortName();
        result = result * 59 + ($portName == null ? 43 : $portName.hashCode());
        String $requestCPU = this.getRequestCPU();
        result = result * 59 + ($requestCPU == null ? 43 : $requestCPU.hashCode());
        String $requestMemory = this.getRequestMemory();
        result = result * 59 + ($requestMemory == null ? 43 : $requestMemory.hashCode());
        String $servicePortName = this.getServicePortName();
        result = result * 59 + ($servicePortName == null ? 43 : $servicePortName.hashCode());
        return result;
    }

    public static enum ImagePullPolicy {
        ALWAYS("Always"),
        NEVER("Never"),
        IFNOTPRESENT("IfNotPresent");

        String value;

        private ImagePullPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

