/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.mount.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configs", "configuration", "enabled", "hotReload", "resources", "volumes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Mount
implements KubernetesResource {
    @JsonProperty(value="configs")
    @JsonPropertyDescription(value="A list of configuration pointing to configmap/secret. The configuration are expected to be UTF-8 resources as they are processed by runtime Camel Context and tried to be parsed as property files. They are also made available on the classpath in order to ease their usage directly from the Route. Syntax: [configmap|secret]:name[/key], where name represents the resource name and key optionally represents the resource key to be filtered")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> configs;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="hotReload")
    @JsonPropertyDescription(value="Enable \"hot reload\" when a secret/configmap mounted is edited (default `false`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean hotReload = false;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="A list of resources (text or binary content) pointing to configmap/secret. The resources are expected to be any resource type (text or binary content). The destination path can be either a default location or any path specified by the user. Syntax: [configmap|secret]:name[/key][@path], where name represents the resource name, key optionally represents the resource key to be filtered and path represents the destination path")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> resources;
    @JsonProperty(value="volumes")
    @JsonPropertyDescription(value="A list of Persistent Volume Claims to be mounted. Syntax: [pvcname:/container/path]")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> volumes;

    public List<String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getHotReload() {
        return this.hotReload;
    }

    public void setHotReload(Boolean hotReload) {
        this.hotReload = hotReload;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public String toString() {
        return "Mount(configs=" + this.getConfigs() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", hotReload=" + this.getHotReload() + ", resources=" + this.getResources() + ", volumes=" + this.getVolumes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mount)) {
            return false;
        }
        Mount other = (Mount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$hotReload = this.getHotReload();
        Boolean other$hotReload = other.getHotReload();
        if (this$hotReload == null ? other$hotReload != null : !((Object)this$hotReload).equals(other$hotReload)) {
            return false;
        }
        List<String> this$configs = this.getConfigs();
        List<String> other$configs = other.getConfigs();
        if (this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$resources = this.getResources();
        List<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $hotReload = this.getHotReload();
        result = result * 59 + ($hotReload == null ? 43 : ((Object)$hotReload).hashCode());
        List<String> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        return result;
    }
}

