package org.apache.camel.v1.integrationprofilestatus.traits;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@com.fasterxml.jackson.annotation.JsonPropertyOrder({"configs","configuration","emptyDirs","enabled","hotReload","resources","scanKameletsImplicitLabelSecrets","volumes"})
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@javax.annotation.processing.Generated("io.fabric8.java.generator.CRGeneratorRunner")
@lombok.ToString()
@lombok.EqualsAndHashCode()
@io.sundr.builder.annotations.Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.LabelSelector.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.Container.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.EnvVar.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.ContainerPort.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.Volume.class),
    @io.sundr.builder.annotations.BuildableReference(io.fabric8.kubernetes.api.model.VolumeMount.class)
})
public class Mount implements io.fabric8.kubernetes.api.builder.Editable<MountBuilder>, io.fabric8.kubernetes.api.model.KubernetesResource {

    @java.lang.Override
    public MountBuilder edit() {
        return new MountBuilder(this);
    }

    /**
     * A list of configuration pointing to configmap/secret. The configuration are expected to be UTF-8 resources as they are processed by runtime Camel Context and tried to be parsed as property files. They are also made available on the classpath in order to ease their usage directly from the Route. Syntax: [configmap|secret]:name[/key], where name represents the resource name and key optionally represents the resource key to be filtered
     */
    @com.fasterxml.jackson.annotation.JsonProperty("configs")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("A list of configuration pointing to configmap/secret. The configuration are expected to be UTF-8 resources as they are processed by runtime Camel Context and tried to be parsed as property files. They are also made available on the classpath in order to ease their usage directly from the Route. Syntax: [configmap|secret]:name[/key], where name represents the resource name and key optionally represents the resource key to be filtered")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private java.util.List<String> configs;

    public java.util.List<String> getConfigs() {
        return configs;
    }

    public void setConfigs(java.util.List<String> configs) {
        this.configs = configs;
    }

    /**
     * Legacy trait configuration parameters. Deprecated: for backward compatibility.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("configuration")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private org.apache.camel.v1.integrationprofilestatus.traits.mount.Configuration configuration;

    public org.apache.camel.v1.integrationprofilestatus.traits.mount.Configuration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(org.apache.camel.v1.integrationprofilestatus.traits.mount.Configuration configuration) {
        this.configuration = configuration;
    }

    /**
     * A list of EmptyDir volumes to be mounted. Syntax: [name:/container/path]
     */
    @com.fasterxml.jackson.annotation.JsonProperty("emptyDirs")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("A list of EmptyDir volumes to be mounted. Syntax: [name:/container/path]")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private java.util.List<String> emptyDirs;

    public java.util.List<String> getEmptyDirs() {
        return emptyDirs;
    }

    public void setEmptyDirs(java.util.List<String> emptyDirs) {
        this.emptyDirs = emptyDirs;
    }

    /**
     * Deprecated: no longer in use.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("enabled")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("Deprecated: no longer in use.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private Boolean enabled;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Enable "hot reload" when a secret/configmap mounted is edited (default `false`). The configmap/secret must be marked with `camel.apache.org/integration` label to be taken in account. The resource will be watched for any kind change, also for changes in metadata.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("hotReload")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("Enable \"hot reload\" when a secret/configmap mounted is edited (default `false`). The configmap/secret must be marked with `camel.apache.org/integration` label to be taken in account. The resource will be watched for any kind change, also for changes in metadata.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private Boolean hotReload;

    public Boolean getHotReload() {
        return hotReload;
    }

    public void setHotReload(Boolean hotReload) {
        this.hotReload = hotReload;
    }

    /**
     * A list of resources (text or binary content) pointing to configmap/secret. The resources are expected to be any resource type (text or binary content). The destination path can be either a default location or any path specified by the user. Syntax: [configmap|secret]:name[/key][@path], where name represents the resource name, key optionally represents the resource key to be filtered and path represents the destination path
     */
    @com.fasterxml.jackson.annotation.JsonProperty("resources")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("A list of resources (text or binary content) pointing to configmap/secret. The resources are expected to be any resource type (text or binary content). The destination path can be either a default location or any path specified by the user. Syntax: [configmap|secret]:name[/key][@path], where name represents the resource name, key optionally represents the resource key to be filtered and path represents the destination path")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private java.util.List<String> resources;

    public java.util.List<String> getResources() {
        return resources;
    }

    public void setResources(java.util.List<String> resources) {
        this.resources = resources;
    }

    /**
     * Deprecated: include your properties in an explicit property file backed by a secret. Let the operator to scan for secret labeled with `camel.apache.org/kamelet` and `camel.apache.org/kamelet.configuration`. These secrets are mounted to the application and treated as plain properties file with their key/value list (ie .spec.data["camel.my-property"] = my-value) (default `true`).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("scanKameletsImplicitLabelSecrets")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("Deprecated: include your properties in an explicit property file backed by a secret. Let the operator to scan for secret labeled with `camel.apache.org/kamelet` and `camel.apache.org/kamelet.configuration`. These secrets are mounted to the application and treated as plain properties file with their key/value list (ie .spec.data[\"camel.my-property\"] = my-value) (default `true`).")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private Boolean scanKameletsImplicitLabelSecrets;

    public Boolean getScanKameletsImplicitLabelSecrets() {
        return scanKameletsImplicitLabelSecrets;
    }

    public void setScanKameletsImplicitLabelSecrets(Boolean scanKameletsImplicitLabelSecrets) {
        this.scanKameletsImplicitLabelSecrets = scanKameletsImplicitLabelSecrets;
    }

    /**
     * A list of Persistent Volume Claims to be mounted. Syntax: [pvcname:/container/path]
     */
    @com.fasterxml.jackson.annotation.JsonProperty("volumes")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("A list of Persistent Volume Claims to be mounted. Syntax: [pvcname:/container/path]")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private java.util.List<String> volumes;

    public java.util.List<String> getVolumes() {
        return volumes;
    }

    public void setVolumes(java.util.List<String> volumes) {
        this.volumes = volumes;
    }
}

