/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilespec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilespec.traits.Prometheus;
import org.apache.camel.v1.integrationprofilespec.traits.prometheus.Configuration;
import org.apache.camel.v1.integrationprofilespec.traits.prometheus.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilespec.traits.prometheus.ConfigurationFluent;

public class PrometheusFluent<A extends PrometheusFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean podMonitor;
    private List<String> podMonitorLabels;

    public PrometheusFluent() {
    }

    public PrometheusFluent(Prometheus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Prometheus instance) {
        Prometheus prometheus = instance = instance != null ? instance : new Prometheus();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withPodMonitor(instance.getPodMonitor());
            this.withPodMonitorLabels(instance.getPodMonitorLabels());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getPodMonitor() {
        return this.podMonitor;
    }

    public A withPodMonitor(Boolean podMonitor) {
        this.podMonitor = podMonitor;
        return (A)((Object)this);
    }

    public boolean hasPodMonitor() {
        return this.podMonitor != null;
    }

    public A addToPodMonitorLabels(int index, String item) {
        if (this.podMonitorLabels == null) {
            this.podMonitorLabels = new ArrayList<String>();
        }
        this.podMonitorLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToPodMonitorLabels(int index, String item) {
        if (this.podMonitorLabels == null) {
            this.podMonitorLabels = new ArrayList<String>();
        }
        this.podMonitorLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToPodMonitorLabels(String ... items) {
        if (this.podMonitorLabels == null) {
            this.podMonitorLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podMonitorLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPodMonitorLabels(Collection<String> items) {
        if (this.podMonitorLabels == null) {
            this.podMonitorLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podMonitorLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPodMonitorLabels(String ... items) {
        if (this.podMonitorLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podMonitorLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodMonitorLabels(Collection<String> items) {
        if (this.podMonitorLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podMonitorLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPodMonitorLabels() {
        return this.podMonitorLabels;
    }

    public String getPodMonitorLabel(int index) {
        return this.podMonitorLabels.get(index);
    }

    public String getFirstPodMonitorLabel() {
        return this.podMonitorLabels.get(0);
    }

    public String getLastPodMonitorLabel() {
        return this.podMonitorLabels.get(this.podMonitorLabels.size() - 1);
    }

    public String getMatchingPodMonitorLabel(Predicate<String> predicate) {
        for (String item : this.podMonitorLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodMonitorLabel(Predicate<String> predicate) {
        for (String item : this.podMonitorLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodMonitorLabels(List<String> podMonitorLabels) {
        if (podMonitorLabels != null) {
            this.podMonitorLabels = new ArrayList<String>();
            for (String item : podMonitorLabels) {
                this.addToPodMonitorLabels(item);
            }
        } else {
            this.podMonitorLabels = null;
        }
        return (A)((Object)this);
    }

    public A withPodMonitorLabels(String ... podMonitorLabels) {
        if (this.podMonitorLabels != null) {
            this.podMonitorLabels.clear();
            this._visitables.remove((Object)"podMonitorLabels");
        }
        if (podMonitorLabels != null) {
            for (String item : podMonitorLabels) {
                this.addToPodMonitorLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodMonitorLabels() {
        return this.podMonitorLabels != null && !this.podMonitorLabels.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrometheusFluent that = (PrometheusFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.podMonitor, that.podMonitor)) {
            return false;
        }
        return Objects.equals(this.podMonitorLabels, that.podMonitorLabels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.podMonitor, this.podMonitorLabels, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.podMonitor != null) {
            sb.append("podMonitor:");
            sb.append(this.podMonitor + ",");
        }
        if (this.podMonitorLabels != null && !this.podMonitorLabels.isEmpty()) {
            sb.append("podMonitorLabels:");
            sb.append(this.podMonitorLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withPodMonitor() {
        return this.withPodMonitor(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)PrometheusFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

