/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.camel.v1.KameletSpecBuilder;
import org.apache.camel.v1.kameletspec.DataTypes;
import org.apache.camel.v1.kameletspec.Definition;
import org.apache.camel.v1.kameletspec.Sources;
import org.apache.camel.v1.kameletspec.Template;
import org.apache.camel.v1.kameletspec.Types;
import org.apache.camel.v1.kameletspec.Versions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dataTypes", "definition", "dependencies", "sources", "template", "types", "versions"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class KameletSpec
implements Editable<KameletSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="dataTypes")
    @JsonPropertyDescription(value="data specification types for the events consumed/produced by the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, DataTypes> dataTypes;
    @JsonProperty(value="definition")
    @JsonPropertyDescription(value="defines the formal configuration of the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private Definition definition;
    @JsonProperty(value="dependencies")
    @JsonPropertyDescription(value="Camel dependencies needed by the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> dependencies;
    @JsonProperty(value="sources")
    @JsonPropertyDescription(value="sources in any Camel DSL supported")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sources> sources;
    @JsonProperty(value="template")
    @JsonPropertyDescription(value="the main source in YAML DSL")
    @JsonSetter(nulls=Nulls.SKIP)
    private Template template;
    @JsonProperty(value="types")
    @JsonPropertyDescription(value="Data specification types for the events consumed/produced by the Kamelet.\nDeprecated: In favor of using DataTypes")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Types> types;
    @JsonProperty(value="versions")
    @JsonPropertyDescription(value="The optional versions available for this Kamelet. This field may not be taken in account by Camel core and is meant to support\nany user defined versioning model on cluster only. If the user wants to use any given version, she must materialize a file with\nthe given version specification as the `main` Kamelet spec on the runtime.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Versions> versions;

    public KameletSpecBuilder edit() {
        return new KameletSpecBuilder(this);
    }

    public Map<String, DataTypes> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(Map<String, DataTypes> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Sources> getSources() {
        return this.sources;
    }

    public void setSources(List<Sources> sources) {
        this.sources = sources;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public Map<String, Types> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Types> types) {
        this.types = types;
    }

    public Map<String, Versions> getVersions() {
        return this.versions;
    }

    public void setVersions(Map<String, Versions> versions) {
        this.versions = versions;
    }

    @Generated
    public String toString() {
        return "KameletSpec(dataTypes=" + this.getDataTypes() + ", definition=" + this.getDefinition() + ", dependencies=" + this.getDependencies() + ", sources=" + this.getSources() + ", template=" + this.getTemplate() + ", types=" + this.getTypes() + ", versions=" + this.getVersions() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KameletSpec)) {
            return false;
        }
        KameletSpec other = (KameletSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DataTypes> this$dataTypes = this.getDataTypes();
        Map<String, DataTypes> other$dataTypes = other.getDataTypes();
        if (this$dataTypes == null ? other$dataTypes != null : !((Object)this$dataTypes).equals(other$dataTypes)) {
            return false;
        }
        Definition this$definition = this.getDefinition();
        Definition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<Sources> this$sources = this.getSources();
        List<Sources> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        Template this$template = this.getTemplate();
        Template other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Map<String, Types> this$types = this.getTypes();
        Map<String, Types> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Map<String, Versions> this$versions = this.getVersions();
        Map<String, Versions> other$versions = other.getVersions();
        return !(this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KameletSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DataTypes> $dataTypes = this.getDataTypes();
        result = result * 59 + ($dataTypes == null ? 43 : ((Object)$dataTypes).hashCode());
        Definition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<Sources> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        Template $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Map<String, Types> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Map<String, Versions> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        return result;
    }
}

