/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletspec.versions.datatypes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.kameletspec.versions.datatypes.Types;
import org.apache.camel.v1.kameletspec.versions.datatypes.types.Headers;
import org.apache.camel.v1.kameletspec.versions.datatypes.types.Schema;
import org.apache.camel.v1.kameletspec.versions.datatypes.types.SchemaBuilder;
import org.apache.camel.v1.kameletspec.versions.datatypes.types.SchemaFluent;

public class TypesFluent<A extends TypesFluent<A>>
extends BaseFluent<A> {
    private List<String> dependencies;
    private String description;
    private String format;
    private Map<String, Headers> headers;
    private String mediaType;
    private SchemaBuilder schema;
    private String scheme;

    public TypesFluent() {
    }

    public TypesFluent(Types instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Types instance) {
        Types types = instance = instance != null ? instance : new Types();
        if (instance != null) {
            this.withDependencies(instance.getDependencies());
            this.withDescription(instance.getDescription());
            this.withFormat(instance.getFormat());
            this.withHeaders(instance.getHeaders());
            this.withMediaType(instance.getMediaType());
            this.withSchema(instance.getSchema());
            this.withScheme(instance.getScheme());
        }
    }

    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(String ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getFormat() {
        return this.format;
    }

    public A withFormat(String format) {
        this.format = format;
        return (A)((Object)this);
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public A addToHeaders(String key, Headers value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, Headers>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, Headers> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, Headers>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, Headers> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Headers> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, Headers> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, Headers>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public A withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return (A)((Object)this);
    }

    public boolean hasMediaType() {
        return this.mediaType != null;
    }

    public Schema buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public A withSchema(Schema schema) {
        this._visitables.remove((Object)"schema");
        if (schema != null) {
            this.schema = new SchemaBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get((Object)"schema").remove((Object)this.schema);
        }
        return (A)((Object)this);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(Schema item) {
        return new SchemaNested(item);
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new SchemaBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(Schema item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)((Object)this);
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypesFluent that = (TypesFluent)((Object)o);
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.mediaType, that.mediaType)) {
            return false;
        }
        if (!Objects.equals((Object)this.schema, (Object)that.schema)) {
            return false;
        }
        return Objects.equals(this.scheme, that.scheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependencies, this.description, this.format, this.headers, this.mediaType, this.schema, this.scheme, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.mediaType != null) {
            sb.append("mediaType:");
            sb.append(this.mediaType + ",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append(this.schema + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchemaNested<N>
    extends SchemaFluent<SchemaNested<N>>
    implements Nested<N> {
        SchemaBuilder builder;

        SchemaNested(Schema item) {
            this.builder = new SchemaBuilder(this, item);
        }

        public N and() {
            return (N)TypesFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }
}

