/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2AsyncMDNServerConnection;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS2ConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ConnectionHelper.class);
    private static Map<Integer, AS2ServerConnection> serverConnections = new HashMap<Integer, AS2ServerConnection>();
    private static Map<Integer, AS2AsyncMDNServerConnection> asyncMdnServerConnections = new HashMap<Integer, AS2AsyncMDNServerConnection>();

    private AS2ConnectionHelper() {
    }

    public static AS2ClientConnection createAS2ClientConnection(AS2Configuration configuration) throws IOException {
        return new AS2ClientConnection(configuration.getAs2Version(), configuration.getUserAgent(), configuration.getClientFqdn(), configuration.getTargetHostname(), configuration.getTargetPortNumber(), configuration.getHttpSocketTimeout(), configuration.getHttpConnectionTimeout(), configuration.getHttpConnectionPoolSize(), configuration.getHttpConnectionPoolTtl(), configuration.getSslContext(), configuration.getHostnameVerifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AS2AsyncMDNServerConnection createAS2AsyncMDNServerConnection(AS2Configuration configuration) throws IOException {
        AS2AsyncMDNServerConnection asyncMdnServerConnection = asyncMdnServerConnections.get(configuration.getAsyncMdnPortNumber());
        Map<Integer, AS2AsyncMDNServerConnection> map = asyncMdnServerConnections;
        synchronized (map) {
            if (asyncMdnServerConnection == null) {
                asyncMdnServerConnection = new AS2AsyncMDNServerConnection(configuration.getAsyncMdnPortNumber(), configuration.getSslContext());
                asyncMdnServerConnections.put(configuration.getAsyncMdnPortNumber(), asyncMdnServerConnection);
            }
        }
        return asyncMdnServerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AS2ServerConnection createAS2ServerConnection(AS2Configuration configuration) throws IOException {
        Map<Integer, AS2ServerConnection> map = serverConnections;
        synchronized (map) {
            AS2ServerConnection serverConnection = serverConnections.get(configuration.getServerPortNumber());
            if (serverConnection == null) {
                serverConnection = new AS2ServerConnection(configuration.getAs2Version(), configuration.getServer(), configuration.getServerFqdn(), configuration.getServerPortNumber(), configuration.getSigningAlgorithm(), configuration.getSigningCertificateChain(), configuration.getSigningPrivateKey(), configuration.getDecryptingPrivateKey(), configuration.getMdnMessageTemplate(), configuration.getValidateSigningCertificateChain(), configuration.getSslContext());
                serverConnections.put(configuration.getServerPortNumber(), serverConnection);
            }
            return serverConnection;
        }
    }

    public static void closeAllConnections() {
        AS2ConnectionHelper.closeAllServerConnections();
        AS2ConnectionHelper.closeAllAsyncMdnServerConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllServerConnections() {
        Map<Integer, AS2ServerConnection> map = serverConnections;
        synchronized (map) {
            for (Map.Entry<Integer, AS2ServerConnection> entry : serverConnections.entrySet()) {
                try {
                    int port = entry.getKey();
                    LOG.debug("Stopping and closing AS2ServerConnection on port: {}", (Object)port);
                    AS2ServerConnection conn = entry.getValue();
                    conn.close();
                }
                catch (Exception e) {
                    LOG.debug("Error stopping and closing AS2ServerConnection due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        serverConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllAsyncMdnServerConnections() {
        Map<Integer, AS2AsyncMDNServerConnection> map = asyncMdnServerConnections;
        synchronized (map) {
            for (Map.Entry<Integer, AS2AsyncMDNServerConnection> entry : asyncMdnServerConnections.entrySet()) {
                try {
                    int port = entry.getKey();
                    LOG.debug("Stopping and closing AsyncMdnServerConnection on port: {}", (Object)port);
                    entry.getValue().close();
                }
                catch (Exception e) {
                    LOG.debug("Error stopping and closing AsyncMdnServerConnection due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        asyncMdnServerConnections.clear();
    }
}

