/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.SegmentDecorator;
import org.apache.camel.util.URISupport;

public abstract class AbstractSegmentDecorator
implements SegmentDecorator {
    @Override
    public boolean newSegment() {
        return true;
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        URI uri = URI.create(endpoint.getEndpointUri());
        return uri.getScheme() + ":" + uri.getRawAuthority();
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        segment.putMetadata("component", (Object)("camel-" + URI.create(endpoint.getEndpointUri()).getScheme()));
        segment.putMetadata("camel.uri", (Object)URISupport.sanitizeUri((String)endpoint.getEndpointUri()));
    }

    @Override
    public void post(Entity segment, Exchange exchange, Endpoint endpoint) {
        if (exchange.isFailed()) {
            segment.setFault(true);
            if (exchange.getException() != null) {
                segment.addException((Throwable)exchange.getException());
            }
        }
    }

    public static String stripSchemeAndOptions(Endpoint endpoint) {
        int start = endpoint.getEndpointUri().indexOf(58);
        ++start;
        while (endpoint.getEndpointUri().charAt(start) == '/') {
            ++start;
        }
        int end = endpoint.getEndpointUri().indexOf(63);
        return end == -1 ? endpoint.getEndpointUri().substring(start) : endpoint.getEndpointUri().substring(start, end);
    }

    public static Map<String, String> toQueryParameters(String uri) {
        int index = uri.indexOf(63);
        if (index != -1) {
            String queryString = uri.substring(index + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : queryString.split("&")) {
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
            return map;
        }
        return Collections.emptyMap();
    }
}

