/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryCommand
extends AbstractDdbCommand {
    public QueryCommand(DynamoDbClient ddbClient, Ddb2Configuration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        QueryRequest.Builder query = QueryRequest.builder().tableName(this.determineTableName()).attributesToGet(this.determineAttributeNames()).consistentRead(this.determineConsistentRead()).keyConditions(this.determineKeyConditions()).exclusiveStartKey(this.determineExclusiveStartKey()).limit(this.determineLimit()).scanIndexForward(this.determineScanIndexForward());
        if (this.exchange.getIn().getHeader("CamelAwsDdbIndexName", String.class) != null) {
            query.indexName((String)this.exchange.getIn().getHeader("CamelAwsDdbIndexName", String.class));
        }
        QueryResponse result = this.ddbClient.query((QueryRequest)query.build());
        HashMap<Object, Object> tmp = new HashMap<Object, Object>();
        tmp.put("CamelAwsDdbItems", result.items());
        tmp.put("CamelAwsDdbLastEvaluatedKey", result.hasLastEvaluatedKey() ? result.lastEvaluatedKey() : null);
        tmp.put("CamelAwsDdbConsumedCapacity", result.consumedCapacity());
        tmp.put("CamelAwsDdbCount", result.count());
        this.addToResults(tmp);
    }

    private Boolean determineScanIndexForward() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbScanIndexForward", Boolean.class);
    }

    private Map<String, Condition> determineKeyConditions() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbKeyConditions", Map.class);
    }
}

