/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-kinesis:application-cloudevents", description="Adds CloudEvent headers to the Camel message with AWS Kinesis get records response details")
public class KinesisCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.kinesis.getRecords");
        if (message.getHeaders().containsKey("CamelAwsKinesisPartitionKey")) {
            headers.put("CamelCloudEventSource", "aws.kinesis.partition.key." + (String)message.getHeader("CamelAwsKinesisPartitionKey", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsKinesisShardId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

