/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.felix.connect.PojoServiceRegistryFactoryImpl;
import org.apache.felix.connect.felix.framework.util.Util;
import org.apache.felix.connect.launch.BundleDescriptor;
import org.apache.felix.connect.launch.ClasspathScanner;
import org.apache.felix.connect.launch.PojoServiceRegistry;
import org.apache.felix.connect.launch.PojoServiceRegistryFactory;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelBlueprintHelper {
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final String BUNDLE_FILTER = "(Bundle-SymbolicName=*)";
    public static final String BUNDLE_VERSION = "1.0.0";
    private static final Logger LOG = LoggerFactory.getLogger(CamelBlueprintHelper.class);
    private static final ClassResolver RESOLVER = new DefaultClassResolver();

    private CamelBlueprintHelper() {
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, descriptors, includeTestBundle, BUNDLE_FILTER, BUNDLE_VERSION);
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle, String bundleFilter, String testBundleVersion) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, descriptors, includeTestBundle, bundleFilter, testBundleVersion, null, new String[0][]);
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle, String bundleFilter, String testBundleVersion, String testBundleDirectives, String[] ... configAdminPidFiles) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, descriptors, includeTestBundle, bundleFilter, testBundleVersion, testBundleDirectives, null, configAdminPidFiles);
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle, String bundleFilter, String testBundleVersion, String testBundleDirectives, ClassLoader loader, String[] ... configAdminPidFiles) throws Exception {
        TinyBundle bundle = null;
        TinyBundle configAdminInitBundle = null;
        if (includeTestBundle) {
            bundle = CamelBlueprintHelper.createTestBundle((String)(testBundleDirectives == null ? name : name + ";" + testBundleDirectives), testBundleVersion, descriptors);
        }
        if (configAdminPidFiles != null) {
            configAdminInitBundle = CamelBlueprintHelper.createConfigAdminInitBundle(configAdminPidFiles);
        }
        return CamelBlueprintHelper.createBundleContext(name, bundleFilter, bundle, configAdminInitBundle, loader);
    }

    public static BundleContext createBundleContext(String name, String bundleFilter, TinyBundle bundle) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, bundleFilter, bundle, null, null);
    }

    public static BundleContext createBundleContext(String name, String bundleFilter, TinyBundle bundle, TinyBundle configAdminInitBundle, ClassLoader loader) throws Exception {
        int i;
        String jarName;
        String uid = "" + System.currentTimeMillis();
        String tempDir = "target/bundles/" + uid;
        System.setProperty("org.osgi.framework.storage", tempDir);
        CamelBlueprintHelper.createDirectory(tempDir);
        CamelBlueprintHelper.createDirectory("target/test-bundles");
        LinkedList<BundleDescriptor> bundles = new LinkedList<BundleDescriptor>();
        if (configAdminInitBundle != null) {
            jarName = "configAdminInitBundle-" + uid + ".jar";
            bundles.add(CamelBlueprintHelper.getBundleDescriptor("target/test-bundles/" + jarName, configAdminInitBundle));
        }
        if (bundle != null) {
            jarName = name.toLowerCase(Locale.ENGLISH) + "-" + uid + ".jar";
            bundles.add(CamelBlueprintHelper.getBundleDescriptor("target/test-bundles/" + jarName, bundle));
        }
        List<BundleDescriptor> bundleDescriptors = CamelBlueprintHelper.getBundleDescriptors(bundleFilter, loader);
        int idx1 = -1;
        int idx2 = -1;
        for (i = 0; i < bundleDescriptors.size(); ++i) {
            BundleDescriptor bd = bundleDescriptors.get(i);
            if ("org.apache.felix.configadmin".equals(bd.getHeaders().get("Bundle-SymbolicName"))) {
                idx1 = i;
            }
            if (!"org.apache.aries.blueprint.core".equals(bd.getHeaders().get("Bundle-SymbolicName"))) continue;
            idx2 = i;
        }
        if (idx1 >= 0 && idx2 >= 0 && idx1 > idx2) {
            bundleDescriptors.add(idx2, bundleDescriptors.remove(idx1));
        }
        bundles.addAll(bundleDescriptors);
        if (LOG.isDebugEnabled()) {
            for (i = 0; i < bundles.size(); ++i) {
                BundleDescriptor desc = (BundleDescriptor)bundles.get(i);
                LOG.debug("Bundle #{} -> {}", (Object)i, (Object)desc);
            }
        }
        HashMap<String, LinkedList<BundleDescriptor>> config = new HashMap<String, LinkedList<BundleDescriptor>>();
        config.put(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS, bundles);
        PojoServiceRegistry reg = new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(config);
        return reg.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeBundleContext(BundleContext bundleContext) throws BundleException {
        try {
            if (bundleContext != null) {
                ArrayList<Bundle> bundles = new ArrayList<Bundle>();
                bundles.addAll(Arrays.asList(bundleContext.getBundles()));
                Collections.reverse(bundles);
                for (Bundle bundle : bundles) {
                    LOG.debug("Stopping bundle {}", (Object)bundle);
                    bundle.stop();
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ise = (IllegalStateException)org.apache.camel.util.ObjectHelper.getException(IllegalStateException.class, (Throwable)e);
            if (ise != null) {
                LOG.debug("Error during disposing BundleContext. This exception will be ignored.", (Throwable)e);
            } else {
                LOG.warn("Error during disposing BundleContext. This exception will be ignored.", (Throwable)e);
            }
        }
        finally {
            String tempDir = System.clearProperty("org.osgi.framework.storage");
            if (tempDir != null) {
                LOG.info("Deleting work directory {}", (Object)tempDir);
                CamelBlueprintHelper.deleteDirectory(tempDir);
            }
        }
    }

    public static void setPersistentFileForConfigAdmin(BundleContext bundleContext, String pid, String fileName, final Dictionary props, String symbolicName, Set<Long> bpEvents, boolean expectReload) throws IOException, InterruptedException {
        if (pid != null) {
            if (fileName == null) {
                throw new IllegalArgumentException("The persistent file should not be null");
            }
            File load = new File(fileName);
            LOG.debug("Loading properties from OSGi config admin file: {}", (Object)load);
            org.apache.felix.utils.properties.Properties cfg = new org.apache.felix.utils.properties.Properties(load);
            for (Object key : cfg.keySet()) {
                props.put(key, cfg.get(key));
            }
            ConfigurationAdmin configAdmin = CamelBlueprintHelper.getOsgiService(bundleContext, ConfigurationAdmin.class);
            if (configAdmin != null) {
                final Configuration config = configAdmin.getConfiguration(pid, null);
                LOG.info("Updating ConfigAdmin {} by overriding properties {}", (Object)config, (Object)props);
                if (expectReload) {
                    CamelBlueprintHelper.waitForBlueprintContainer(bpEvents, bundleContext, symbolicName, 2, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                config.update(props);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e.getMessage(), e);
                            }
                        }
                    });
                } else {
                    config.update(props);
                }
            }
        }
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, null, timeout);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, null, 30000L);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, filter, 30000L);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, String filter, long timeout) {
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            ServiceTracker tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                Dictionary dic = bundleContext.getBundle().getHeaders();
                LOG.warn("Test bundle headers: " + CamelBlueprintHelper.explode(dic));
                for (ServiceReference ref : CamelBlueprintHelper.asCollection(bundleContext.getAllServiceReferences(null, null))) {
                    LOG.warn("ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                for (ServiceReference ref : CamelBlueprintHelper.asCollection(bundleContext.getAllServiceReferences(null, flt))) {
                    LOG.warn("Filtered ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForBlueprintContainer(final Set<Long> eventHistory, BundleContext context, final String symbolicName, final int bpEvent, Runnable runAndWait) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final Throwable[] pThrowable = new Throwable[]{null};
        ServiceRegistration registration = context.registerService(BlueprintListener.class, (Object)new BlueprintListener(){

            public void blueprintEvent(BlueprintEvent event) {
                if (event.getBundle().getSymbolicName().equals(symbolicName)) {
                    if (event.getType() == bpEvent) {
                        if (eventHistory == null || eventHistory.add(event.getTimestamp())) {
                            latch.countDown();
                        }
                    } else if (event.getType() == 5) {
                        pThrowable[0] = event.getCause();
                        latch.countDown();
                    }
                }
            }
        }, null);
        if (runAndWait != null) {
            runAndWait.run();
        }
        boolean found = latch.await(30000L, TimeUnit.MILLISECONDS);
        registration.unregister();
        if (!found) {
            throw new RuntimeException("Gave up waiting for BlueprintContainer from bundle \"" + symbolicName + "\"");
        }
        if (pThrowable[0] != null) {
            throw new RuntimeException(pThrowable[0].getMessage(), pThrowable[0]);
        }
    }

    protected static TinyBundle createConfigAdminInitBundle(String[] ... configAdminPidFiles) throws IOException {
        TinyBundle bundle = TinyBundles.bundle();
        StringWriter configAdminInit = null;
        for (String[] configAdminPidFile : configAdminPidFiles) {
            if (configAdminPidFile == null) continue;
            if (configAdminInit == null) {
                configAdminInit = new StringWriter();
            } else {
                configAdminInit.append(',');
            }
            configAdminInit.append(configAdminPidFile[1]).append("=");
            configAdminInit.append(new File(configAdminPidFile[0]).toURI().toString());
        }
        bundle.add(TestBundleActivator.class);
        bundle.add(Util.class);
        bundle.set("Manifest-Version", "2").set("Bundle-ManifestVersion", "2").set("Bundle-SymbolicName", "ConfigAdminInit").set("Bundle-Version", BUNDLE_VERSION).set("Bundle-Activator", TestBundleActivator.class.getName());
        if (configAdminInit != null) {
            bundle.set("X-Camel-Blueprint-ConfigAdmin-Init", configAdminInit.toString());
        }
        return bundle;
    }

    protected static TinyBundle createTestBundle(String name, String version, String descriptors) throws IOException {
        TinyBundle bundle = TinyBundles.bundle();
        for (URL url : CamelBlueprintHelper.getBlueprintDescriptors(descriptors)) {
            LOG.info("Using Blueprint XML file: " + url.getFile());
            bundle.add("OSGI-INF/blueprint/blueprint-" + url.getFile().replace("/", "-"), url);
        }
        bundle.set("Manifest-Version", "2").set("Bundle-ManifestVersion", "2").set("Bundle-SymbolicName", name).set("Bundle-Version", version);
        return bundle;
    }

    private static String explode(Dictionary<?, ?> dictionary) {
        Enumeration<?> keys = dictionary.keys();
        StringBuilder result = new StringBuilder();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static void createDirectory(String file) {
        File dir = new File(file);
        dir.mkdirs();
    }

    public static boolean deleteDirectory(String file) {
        return CamelBlueprintHelper.deleteDirectory(new File(file));
    }

    public static boolean deleteDirectory(File file) {
        int tries = 0;
        int maxTries = 5;
        boolean exists = true;
        while (exists && tries < maxTries) {
            CamelBlueprintHelper.recursivelyDeleteDirectory(file);
            ++tries;
            exists = file.exists();
            if (!exists) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !exists;
    }

    private static void recursivelyDeleteDirectory(File file) {
        boolean success;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                CamelBlueprintHelper.recursivelyDeleteDirectory(child);
            }
        }
        if (!(success = file.delete())) {
            LOG.warn("Deletion of file: " + file.getAbsolutePath() + " failed");
        }
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references == null ? new ArrayList(0) : Arrays.asList(references);
    }

    private static List<BundleDescriptor> getBundleDescriptors(String bundleFilter, ClassLoader loader) throws Exception {
        return new ClasspathScanner().scanForBundles(bundleFilter, loader);
    }

    public static Collection<URL> getBlueprintDescriptors(String descriptors) throws FileNotFoundException, MalformedURLException {
        ArrayList<URL> answer = new ArrayList<URL>();
        if (descriptors != null) {
            Iterator it = ObjectHelper.createIterator((Object)descriptors);
            while (it.hasNext()) {
                String s = (String)it.next();
                LOG.trace("Resource descriptor: {}", (Object)s);
                s = FileUtil.stripLeadingSeparator((String)s);
                if (s.endsWith("*.xml")) {
                    String packageName = s.substring(0, s.length() - 5);
                    Enumeration urls = org.apache.camel.util.ObjectHelper.loadResourcesAsURL((String)packageName);
                    while (urls.hasMoreElements()) {
                        File[] files;
                        URL url = (URL)urls.nextElement();
                        File dir = new File(url.getFile());
                        if (!dir.isDirectory() || (files = dir.listFiles()) == null) continue;
                        for (File file : files) {
                            if (!file.isFile() || !file.exists() || !file.getName().endsWith(".xml")) continue;
                            String name = packageName + file.getName();
                            LOG.debug("Resolving resource: {}", (Object)name);
                            URL xmlUrl = org.apache.camel.util.ObjectHelper.loadResourceAsURL((String)name);
                            if (xmlUrl == null) continue;
                            answer.add(xmlUrl);
                        }
                    }
                    continue;
                }
                LOG.debug("Resolving resource: {}", (Object)s);
                URL url = RESOLVER.loadResourceAsURL(s);
                if (url == null) {
                    throw new FileNotFoundException("Resource " + s + " not found");
                }
                answer.add(url);
            }
        } else {
            throw new IllegalArgumentException("No bundle descriptor configured. Override getBlueprintDescriptor() or getBlueprintDescriptors() method");
        }
        if (answer.isEmpty()) {
            throw new IllegalArgumentException("Cannot find any resources in classpath from descriptor " + descriptors);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BundleDescriptor getBundleDescriptor(String path, TinyBundle bundle) throws Exception {
        BundleDescriptor answer;
        File file = new File(path);
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file, false);
        InputStream is = bundle.build();
        try {
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, fos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, fos});
        FileInputStream fis = null;
        JarInputStream jis = null;
        try {
            fis = new FileInputStream(file);
            jis = new JarInputStream(fis);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : jis.getManifest().getMainAttributes().entrySet()) {
                headers.put(entry.getKey().toString(), entry.getValue().toString());
            }
            answer = new BundleDescriptor(bundle.getClass().getClassLoader(), "jar:" + file.toURI().toString() + "!/", headers);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{jis, fis});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{jis, fis});
        return answer;
    }

    public static class TestBundleActivator
    implements BundleActivator {
        public void start(BundleContext bundleContext) throws Exception {
            final String configAdminInit = (String)bundleContext.getBundle().getHeaders().get("X-Camel-Blueprint-ConfigAdmin-Init");
            if (configAdminInit != null) {
                final BundleContext sysContext = bundleContext.getBundle(0L).getBundleContext();
                sysContext.addBundleListener((BundleListener)new SynchronousBundleListener(){

                    public void bundleChanged(BundleEvent event) {
                        ServiceReference sr;
                        if (event.getType() == 2 && "org.apache.felix.configadmin".equals(event.getBundle().getSymbolicName()) && (sr = sysContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin")) != null && sysContext.getService(sr) != null) {
                            this.initializeConfigAdmin(sysContext, configAdminInit);
                        }
                    }
                });
            }
        }

        private void initializeConfigAdmin(BundleContext context, String configAdminInit) {
            String[] pidFiles;
            for (String pidFile : pidFiles = configAdminInit.split(",")) {
                String[] pf = pidFile.split("=");
                try {
                    CamelBlueprintHelper.setPersistentFileForConfigAdmin(context, pf[0], new URI(pf[1]).getPath(), new Properties(), null, null, false);
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }

        public void stop(BundleContext bundleContext) throws Exception {
        }
    }
}

