/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.blueprint.BlueprintCamelContextLookupHelper;
import org.apache.camel.blueprint.ErrorHandlerType;
import org.apache.camel.builder.LegacyDefaultErrorHandlerBuilder;
import org.apache.camel.builder.LegacyErrorHandlerBuilder;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.osgi.service.blueprint.container.BlueprintContainer;

@XmlRootElement(name="errorHandler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelErrorHandlerFactoryBean
extends AbstractCamelFactoryBean<LegacyErrorHandlerBuilder> {
    @XmlAttribute
    private ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
    @XmlAttribute
    private String deadLetterUri;
    @XmlAttribute
    private Boolean deadLetterHandleNewException;
    @XmlAttribute
    private Boolean useOriginalMessage;
    @XmlAttribute
    private Boolean useOriginalBody;
    @XmlAttribute
    private String onRedeliveryRef;
    @XmlAttribute
    private String onPrepareFailureRef;
    @XmlAttribute
    private String onExceptionOccurredRef;
    @XmlAttribute
    private String retryWhileRef;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String redeliveryPolicyRef;
    @XmlElement
    private RedeliveryPolicyDefinition redeliveryPolicy;
    @XmlTransient
    private BlueprintContainer blueprintContainer;

    public LegacyErrorHandlerBuilder getObject() throws Exception {
        LegacyErrorHandlerBuilder errorHandler = this.getObjectType().newInstance();
        if (errorHandler instanceof LegacyDefaultErrorHandlerBuilder) {
            LegacyDefaultErrorHandlerBuilder handler = (LegacyDefaultErrorHandlerBuilder)errorHandler;
            if (this.deadLetterUri != null) {
                handler.setDeadLetterUri(this.deadLetterUri);
            }
            if (this.deadLetterHandleNewException != null) {
                handler.setDeadLetterHandleNewException(this.deadLetterHandleNewException.booleanValue());
            }
            if (this.useOriginalMessage != null) {
                handler.setUseOriginalMessage(this.useOriginalMessage.booleanValue());
            }
            if (this.useOriginalBody != null) {
                handler.setUseOriginalBody(this.useOriginalBody.booleanValue());
            }
            if (this.redeliveryPolicy != null) {
                handler.setRedeliveryPolicy(ErrorHandlerReifier.createRedeliveryPolicy((RedeliveryPolicyDefinition)this.redeliveryPolicy, (CamelContext)this.getCamelContext(), null));
            }
            if (this.redeliveryPolicyRef != null) {
                handler.setRedeliveryPolicy(this.lookup(this.redeliveryPolicyRef, RedeliveryPolicy.class));
            }
            if (this.onRedeliveryRef != null) {
                handler.setOnRedelivery(this.lookup(this.onRedeliveryRef, Processor.class));
            }
            if (this.onPrepareFailureRef != null) {
                handler.setOnPrepareFailure(this.lookup(this.onPrepareFailureRef, Processor.class));
            }
            if (this.onExceptionOccurredRef != null) {
                handler.setOnExceptionOccurred(this.lookup(this.onExceptionOccurredRef, Processor.class));
            }
            if (this.retryWhileRef != null) {
                handler.setRetryWhileRef(this.retryWhileRef);
            }
            if (this.executorServiceRef != null) {
                handler.setExecutorServiceRef(this.executorServiceRef);
            }
        }
        return errorHandler;
    }

    public Class<? extends LegacyErrorHandlerBuilder> getObjectType() {
        return this.type.getTypeAsClass();
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    protected CamelContext getCamelContextWithId(String camelContextId) {
        if (this.blueprintContainer != null) {
            return (CamelContext)this.blueprintContainer.getComponentInstance(camelContextId);
        }
        return null;
    }

    protected CamelContext discoverDefaultCamelContext() {
        Set<String> ids;
        if (this.blueprintContainer != null && (ids = BlueprintCamelContextLookupHelper.lookupBlueprintCamelContext(this.blueprintContainer)).size() == 1) {
            return this.getCamelContextWithId(ids.iterator().next());
        }
        return null;
    }

    protected <T> T lookup(String name, Class<T> type) {
        return type.cast(this.blueprintContainer.getComponentInstance(name));
    }
}

