/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint.handler;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.BlueprintCamelStateService;
import org.apache.camel.blueprint.BlueprintModelJAXBContextFactory;
import org.apache.camel.blueprint.CamelContextFactoryBean;
import org.apache.camel.blueprint.CamelEndpointFactoryBean;
import org.apache.camel.blueprint.CamelRestContextFactoryBean;
import org.apache.camel.blueprint.CamelRouteConfigurationContextFactoryBean;
import org.apache.camel.blueprint.CamelRouteContextFactoryBean;
import org.apache.camel.blueprint.CamelRouteTemplateContextFactoryBean;
import org.apache.camel.builder.LegacyDeadLetterChannelBuilder;
import org.apache.camel.builder.LegacyDefaultErrorHandlerBuilder;
import org.apache.camel.builder.LegacyNoErrorHandlerBuilder;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.LegacyDeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.LegacyDefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.LegacyNoErrorHandlerReifier;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.builder.xml.NamespacesHelper;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SecureRandomParameters;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.blueprint.KeyStoreParametersFactoryBean;
import org.apache.camel.util.blueprint.SSLContextParametersFactoryBean;
import org.apache.camel.util.blueprint.SecureRandomParametersFactoryBean;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CamelNamespaceHandler
implements NamespaceHandler {
    public static final String BLUEPRINT_NS = "http://camel.apache.org/schema/blueprint";
    public static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final String CAMEL_CONTEXT = "camelContext";
    private static final String ROUTE_CONTEXT = "routeContext";
    private static final String ROUTE_CONFIGURATION_CONTEXT = "routeConfigurationContext";
    private static final String ROUTE_TEMPLATE_CONTEXT = "routeTemplateContext";
    private static final String REST_CONTEXT = "restContext";
    private static final String ENDPOINT = "endpoint";
    private static final String KEY_STORE_PARAMETERS = "keyStoreParameters";
    private static final String SECURE_RANDOM_PARAMETERS = "secureRandomParameters";
    private static final String SSL_CONTEXT_PARAMETERS = "sslContextParameters";
    private static final Logger LOG;
    private JAXBContext jaxbContext;

    public static void doBeforeParse(Node node, String fromNamespace, String toNamespace) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (node.getNamespaceURI().equals(fromNamespace)) {
                doc.renameNode(node, toNamespace, node.getLocalName());
            }
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                String changed;
                Node att = map.item(i);
                if (!att.getNodeName().equals("uri") && !att.getNodeName().endsWith("Uri")) continue;
                String value = att.getNodeValue();
                String before = StringHelper.before((String)value, (String)"?");
                String after = StringHelper.after((String)value, (String)"?");
                if (before == null || after == null || after.equals(changed = after.replaceAll("\\s{2,}", ""))) continue;
                String newAtr = before.trim() + "?" + changed.trim();
                LOG.debug("Removed whitespace noise from attribute {} -> {}", (Object)value, (Object)newAtr);
                att.setNodeValue(newAtr);
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.doBeforeParse(list.item(i), fromNamespace, toNamespace);
        }
    }

    public URL getSchemaLocation(String namespace) {
        if (BLUEPRINT_NS.equals(namespace)) {
            return this.getClass().getClassLoader().getResource("camel-blueprint.xsd");
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCamelContext.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata parse(Element element, ParserContext context) {
        LOG.trace("Parsing element {}", (Object)element);
        try {
            CamelNamespaceHandler.doBeforeParse(element, BLUEPRINT_NS, SPRING_NS);
            if (element.getLocalName().equals(CAMEL_CONTEXT)) {
                Metadata metadata = this.parseCamelContextNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(ROUTE_CONTEXT)) {
                Metadata metadata = this.parseRouteContextNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(ROUTE_CONFIGURATION_CONTEXT)) {
                Metadata metadata = this.parseRouteConfigurationContextNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(ROUTE_TEMPLATE_CONTEXT)) {
                Metadata metadata = this.parseRouteTemplateContextNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(REST_CONTEXT)) {
                Metadata metadata = this.parseRestContextNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(ENDPOINT)) {
                Metadata metadata = this.parseEndpointNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(KEY_STORE_PARAMETERS)) {
                Metadata metadata = this.parseKeyStoreParametersNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(SECURE_RANDOM_PARAMETERS)) {
                Metadata metadata = this.parseSecureRandomParametersNode(element, context);
                return metadata;
            }
            if (element.getLocalName().equals(SSL_CONTEXT_PARAMETERS)) {
                Metadata metadata = this.parseSSLContextParametersNode(element, context);
                return metadata;
            }
        }
        finally {
            CamelNamespaceHandler.doBeforeParse(element, SPRING_NS, BLUEPRINT_NS);
        }
        return null;
    }

    private Metadata parseCamelContextNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing CamelContext {}", (Object)element);
        String contextId = element.getAttribute("id");
        boolean implicitId = false;
        if (org.apache.camel.util.ObjectHelper.isEmpty((String)contextId)) {
            DefaultCamelContextNameStrategy strategy = new DefaultCamelContextNameStrategy();
            contextId = strategy.getName();
            element.setAttributeNS(null, "id", contextId);
            implicitId = true;
        }
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelContextFactoryBean.class);
        }
        CamelContextFactoryBean ccfb = (CamelContextFactoryBean)((Object)value);
        ccfb.setImplicitId(implicitId);
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + contextId);
        factory.setObject(new PassThroughCallable<Object>(value));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + contextId);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        factory2.addProperty("bundleContext", (Metadata)this.createRef(context, "blueprintBundleContext"));
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)ccfb.getDependsOn())) {
            factory2.setDependsOn(Arrays.asList(ccfb.getDependsOn().split(" |,")));
        }
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factory2);
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(contextId);
        ctx.setRuntimeClass(BlueprintCamelContext.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getContext");
        ctx.addProperty("bundleStateService", (Metadata)this.createRef(context, ".camelBlueprint.bundleStateService"));
        ctx.setInitMethod("build");
        ctx.setDestroyMethod("destroy");
        this.registerBeans(context, contextId, ccfb.getThreadPools());
        this.registerBeans(context, contextId, ccfb.getEndpoints());
        this.registerBeans(context, contextId, ccfb.getRedeliveryPolicies());
        this.registerBeans(context, contextId, ccfb.getBeansFactory());
        this.registerBundleStateService(context);
        MutablePassThroughMetadata beanProcessorFactory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        beanProcessorFactory.setId(".camelBlueprint.processor.bean.passThrough." + contextId);
        beanProcessorFactory.setObject(new PassThroughCallable<CamelInjector>(new CamelInjector(contextId)));
        MutableBeanMetadata beanProcessor = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        beanProcessor.setId(".camelBlueprint.processor.bean." + contextId);
        beanProcessor.setRuntimeClass(CamelInjector.class);
        beanProcessor.setFactoryComponent((Target)beanProcessorFactory);
        beanProcessor.setFactoryMethod("call");
        beanProcessor.setProcessor(true);
        beanProcessor.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)beanProcessor);
        MutablePassThroughMetadata regProcessorFactory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        regProcessorFactory.setId(".camelBlueprint.processor.registry.passThrough." + contextId);
        regProcessorFactory.setObject(new PassThroughCallable<CamelDependenciesFinder>(new CamelDependenciesFinder(contextId, context)));
        MutableBeanMetadata regProcessor = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        regProcessor.setId(".camelBlueprint.processor.registry." + contextId);
        regProcessor.setRuntimeClass(CamelDependenciesFinder.class);
        regProcessor.setFactoryComponent((Target)regProcessorFactory);
        regProcessor.setFactoryMethod("call");
        regProcessor.setProcessor(true);
        regProcessor.addDependsOn(".camelBlueprint.processor.bean." + contextId);
        regProcessor.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)regProcessor);
        this.injectNamespaces(element, (Binder<Node>)binder);
        LOG.trace("Parsing CamelContext done, returning {}", (Object)ctx);
        return ctx;
    }

    protected void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = NamespacesHelper.namespaces((Element)element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement, binder);
        }
    }

    private Metadata parseRouteContextNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing RouteContext {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelRouteContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelRouteContextFactoryBean.class);
        }
        CamelRouteContextFactoryBean rcfb = (CamelRouteContextFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelRouteContextFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getRoutes");
        ctx.setActivation(2);
        this.injectNamespaces(element, (Binder<Node>)binder);
        LOG.trace("Parsing RouteContext {} done, returning {}", (Object)element, (Object)ctx);
        return ctx;
    }

    private Metadata parseRouteConfigurationContextNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing RouteConfigurationContext {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelRouteConfigurationContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelRouteConfigurationContextFactoryBean.class);
        }
        CamelRouteConfigurationContextFactoryBean rcfb = (CamelRouteConfigurationContextFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelRouteConfigurationContextFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getRouteConfigurations");
        ctx.setActivation(2);
        this.injectNamespaces(element, (Binder<Node>)binder);
        LOG.trace("Parsing RouteConfigurationContext {} done, returning {}", (Object)element, (Object)ctx);
        return ctx;
    }

    private Metadata parseRouteTemplateContextNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing RouteTemplateContext {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelRouteTemplateContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelRouteTemplateContextFactoryBean.class);
        }
        CamelRouteTemplateContextFactoryBean rcfb = (CamelRouteTemplateContextFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelRouteTemplateContextFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getRouteTemplates");
        ctx.setActivation(2);
        this.injectNamespaces(element, (Binder<Node>)binder);
        LOG.trace("Parsing RouteTemplateContext {} done, returning {}", (Object)element, (Object)ctx);
        return ctx;
    }

    private Metadata parseRestContextNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing RestContext {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelRestContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelRestContextFactoryBean.class);
        }
        CamelRestContextFactoryBean rcfb = (CamelRestContextFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelRestContextFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getRests");
        ctx.setActivation(2);
        this.injectNamespaces(element, (Binder<Node>)binder);
        LOG.trace("Parsing RestContext {} done, returning {}", (Object)element, (Object)ctx);
        return ctx;
    }

    private Metadata parseEndpointNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing Endpoint {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelEndpointFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelEndpointFactoryBean.class);
        }
        CamelEndpointFactoryBean rcfb = (CamelEndpointFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelEndpointFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(Endpoint.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        ctx.setActivation(2);
        LOG.trace("Parsing endpoint {} done, returning {}", (Object)element, (Object)ctx);
        return ctx;
    }

    private Metadata parseKeyStoreParametersNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing KeyStoreParameters {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof KeyStoreParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + KeyStoreParametersFactoryBean.class);
        }
        KeyStoreParametersFactoryBean kspfb = (KeyStoreParametersFactoryBean)((Object)value);
        String id = kspfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<KeyStoreParametersFactoryBean>(kspfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(KeyStoreParameters.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        ctx.setActivation(2);
        LOG.trace("Parsing KeyStoreParameters done, returning {}", (Object)ctx);
        return ctx;
    }

    private Metadata parseSecureRandomParametersNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing SecureRandomParameters {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof SecureRandomParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + SecureRandomParametersFactoryBean.class);
        }
        SecureRandomParametersFactoryBean srfb = (SecureRandomParametersFactoryBean)((Object)value);
        String id = srfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<SecureRandomParametersFactoryBean>(srfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(SecureRandomParameters.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        ctx.setActivation(2);
        LOG.trace("Parsing SecureRandomParameters done, returning {}", (Object)ctx);
        return ctx;
    }

    private Metadata parseSSLContextParametersNode(Element element, ParserContext context) {
        Binder binder;
        LOG.trace("Parsing SSLContextParameters {}", (Object)element);
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder: " + e, (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof SSLContextParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + SSLContextParametersFactoryBean.class);
        }
        SSLContextParametersFactoryBean scpfb = (SSLContextParametersFactoryBean)((Object)value);
        String id = scpfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<SSLContextParametersFactoryBean>(scpfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(SSLContextParameters.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        ctx.setActivation(2);
        LOG.trace("Parsing SSLContextParameters done, returning {}", (Object)ctx);
        return ctx;
    }

    private void registerBeans(ParserContext context, String contextId, List<?> beans) {
        if (beans != null) {
            for (Object bean : beans) {
                if (!(bean instanceof AbstractCamelFactoryBean)) continue;
                this.registerBean(context, contextId, (AbstractCamelFactoryBean)bean);
            }
        }
    }

    protected void registerBean(ParserContext context, String contextId, AbstractCamelFactoryBean<?> fact) {
        String id = fact.getId();
        fact.setCamelContextId(contextId);
        MutablePassThroughMetadata eff = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        eff.setId(".camelBlueprint.bean.passthrough." + id);
        eff.setObject(new PassThroughCallable(fact));
        MutableBeanMetadata ef = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ef.setId(".camelBlueprint.bean.factory." + id);
        ef.setFactoryComponent((Target)eff);
        ef.setFactoryMethod("call");
        ef.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        ef.setInitMethod("afterPropertiesSet");
        ef.setDestroyMethod("destroy");
        MutableBeanMetadata e = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        e.setId(id);
        e.setRuntimeClass(fact.getObjectType());
        e.setFactoryComponent((Target)ef);
        e.setFactoryMethod("getObject");
        e.addDependsOn(".camelBlueprint.processor.bean." + contextId);
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)e);
    }

    private void registerBundleStateService(ParserContext context) {
        ComponentDefinitionRegistry componentDefinitionRegistry = context.getComponentDefinitionRegistry();
        ComponentMetadata cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.bundleStateService");
        if (cm == null) {
            MutableBeanMetadata ssm = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            ssm.setId(".camelBlueprint.bundleStateService");
            ssm.setRuntimeClass(BlueprintCamelStateService.class);
            ssm.addProperty("bundleContext", (Metadata)this.createRef(context, "blueprintBundleContext"));
            ssm.setInitMethod("init");
            ssm.setDestroyMethod("destroy");
            componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)ssm);
        }
    }

    protected BlueprintContainer getBlueprintContainer(ParserContext context) {
        PassThroughMetadata ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintContainer");
        return (BlueprintContainer)ptm.getObject();
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to parse JAXB element: " + e, (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = new BlueprintModelJAXBContextFactory(this.getClass().getClassLoader()).newJAXBContext();
        }
        return this.jaxbContext;
    }

    private RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata r = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        r.setComponentId(value);
        return r;
    }

    private static ComponentMetadata getDataformatResolverReference(ParserContext context, String dataformat) {
        if (dataformat.startsWith("{{")) {
            return null;
        }
        ComponentDefinitionRegistry componentDefinitionRegistry = context.getComponentDefinitionRegistry();
        ComponentMetadata cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.dataformatResolver." + dataformat);
        if (cm == null) {
            MutableReferenceMetadata svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
            svc.setId(".camelBlueprint.dataformatResolver." + dataformat);
            svc.setFilter("(dataformat=" + dataformat + ")");
            svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(dataformat) ? 2 : 1);
            try {
                svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, DataFormatResolver.class);
            }
            catch (Throwable t) {
                try {
                    PassThroughMetadata ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                    Bundle b = (Bundle)ptm.getObject();
                    if (b.loadClass(DataFormatResolver.class.getName()) != DataFormatResolver.class) {
                        throw new UnsupportedOperationException();
                    }
                    svc.setInterface(DataFormatResolver.class.getName());
                }
                catch (Throwable t2) {
                    throw new UnsupportedOperationException();
                }
            }
            componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
            cm = svc;
        }
        return cm;
    }

    private static ComponentMetadata getLanguageResolverReference(ParserContext context, String language) {
        if (language.startsWith("{{")) {
            return null;
        }
        ComponentDefinitionRegistry componentDefinitionRegistry = context.getComponentDefinitionRegistry();
        ComponentMetadata cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.languageResolver." + language);
        if (cm == null) {
            MutableReferenceMetadata svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
            svc.setId(".camelBlueprint.languageResolver." + language);
            svc.setFilter("(language=" + language + ")");
            svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(language) ? 2 : 1);
            try {
                svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, LanguageResolver.class);
            }
            catch (Throwable t) {
                try {
                    PassThroughMetadata ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                    Bundle b = (Bundle)ptm.getObject();
                    if (b.loadClass(LanguageResolver.class.getName()) != LanguageResolver.class) {
                        throw new UnsupportedOperationException();
                    }
                    svc.setInterface(LanguageResolver.class.getName());
                }
                catch (Throwable t2) {
                    throw new UnsupportedOperationException();
                }
            }
            componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
            cm = svc;
        }
        return cm;
    }

    private static ComponentMetadata getComponentResolverReference(ParserContext context, String component) {
        if (component.startsWith("{{")) {
            return null;
        }
        ComponentDefinitionRegistry componentDefinitionRegistry = context.getComponentDefinitionRegistry();
        ComponentMetadata cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.componentResolver." + component);
        if (cm == null) {
            MutableReferenceMetadata svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
            svc.setId(".camelBlueprint.componentResolver." + component);
            svc.setFilter("(component=" + component + ")");
            svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(component) ? 2 : 1);
            try {
                svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, ComponentResolver.class);
            }
            catch (Throwable t) {
                try {
                    PassThroughMetadata ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                    Bundle b = (Bundle)ptm.getObject();
                    if (b.loadClass(ComponentResolver.class.getName()) != ComponentResolver.class) {
                        throw new UnsupportedOperationException();
                    }
                    svc.setInterface(ComponentResolver.class.getName());
                }
                catch (Throwable t2) {
                    throw new UnsupportedOperationException();
                }
            }
            componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
            cm = svc;
        }
        return cm;
    }

    static {
        ErrorHandlerReifier.registerReifier(LegacyDeadLetterChannelBuilder.class, LegacyDeadLetterChannelReifier::new);
        ErrorHandlerReifier.registerReifier(LegacyDefaultErrorHandlerBuilder.class, LegacyDefaultErrorHandlerReifier::new);
        ErrorHandlerReifier.registerReifier(LegacyNoErrorHandlerBuilder.class, LegacyNoErrorHandlerReifier::new);
        LOG = LoggerFactory.getLogger(CamelNamespaceHandler.class);
    }

    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }

    public static class CamelInjector
    extends CamelPostProcessorHelper
    implements BeanProcessor {
        private final String camelContextName;
        private BlueprintContainer blueprintContainer;

        public CamelInjector(String camelContextName) {
            this.camelContextName = camelContextName;
        }

        public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
            this.blueprintContainer = blueprintContainer;
        }

        public CamelContext getCamelContext() {
            if (this.blueprintContainer != null) {
                CamelContext answer = (CamelContext)this.blueprintContainer.getComponentInstance(this.camelContextName);
                return answer;
            }
            return null;
        }

        public Object beforeInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
            LOG.trace("Before init of bean: {} -> {}", (Object)beanName, bean);
            return bean;
        }

        protected void injectFields(Object bean, String beanName) {
            Class<?> clazz = bean.getClass();
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Produce produce;
                    EndpointInject endpointInject;
                    BeanInject beanInject;
                    PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
                    if (propertyInject != null) {
                        this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
                    }
                    if ((beanInject = field.getAnnotation(BeanInject.class)) != null) {
                        this.injectFieldBean(field, beanInject.value(), bean, beanName);
                    }
                    if ((endpointInject = field.getAnnotation(EndpointInject.class)) != null) {
                        String uri = endpointInject.value().isEmpty() ? endpointInject.uri() : endpointInject.value();
                        this.injectField(field, uri, endpointInject.property(), bean, beanName);
                    }
                    if ((produce = field.getAnnotation(Produce.class)) == null) continue;
                    String uri = produce.value().isEmpty() ? produce.uri() : produce.value();
                    this.injectField(field, uri, produce.property(), bean, beanName);
                }
            } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        }

        protected void injectField(Field field, String endpointUri, String endpointProperty, Object bean, String beanName) {
            CamelInjector.setField(field, bean, this.getInjectionValue(field.getType(), endpointUri, endpointProperty, field.getName(), bean, beanName));
        }

        protected void injectFieldProperty(Field field, String propertyName, String propertyDefaultValue, Object bean, String beanName) {
            CamelInjector.setField(field, bean, this.getInjectionPropertyValue(field.getType(), propertyName, propertyDefaultValue, field.getName(), bean, beanName));
        }

        public void injectFieldBean(Field field, String name, Object bean, String beanName) {
            CamelInjector.setField(field, bean, this.getInjectionBeanValue(field.getType(), name));
        }

        protected static void setField(Field field, Object instance, Object value) {
            try {
                boolean shouldSetAccessible;
                boolean oldAccessible = field.isAccessible();
                boolean bl = shouldSetAccessible = !Modifier.isPublic(field.getModifiers()) && !oldAccessible;
                if (shouldSetAccessible) {
                    field.setAccessible(true);
                }
                field.set(instance, value);
                if (shouldSetAccessible) {
                    field.setAccessible(oldAccessible);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Cannot inject value of class: " + value.getClass() + " into: " + field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Could not access method: " + ex.getMessage());
            }
        }

        protected void injectMethods(Object bean, String beanName) {
            Class<?> clazz = bean.getClass();
            do {
                Method[] methods;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    this.setterInjection(method, bean, beanName);
                    this.consumerInjection(method, bean, beanName);
                }
            } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        }

        protected void setterInjection(Method method, Object bean, String beanName) {
            Produce produce;
            EndpointInject endpointInject;
            BeanInject beanInject;
            PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
            if (propertyInject != null) {
                this.setterPropertyInjection(method, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
            }
            if ((beanInject = method.getAnnotation(BeanInject.class)) != null) {
                this.setterBeanInjection(method, beanInject.value(), bean, beanName);
            }
            if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null) {
                String uri = endpointInject.value().isEmpty() ? endpointInject.uri() : endpointInject.value();
                this.setterInjection(method, bean, beanName, uri, endpointInject.property());
            }
            if ((produce = method.getAnnotation(Produce.class)) != null) {
                String uri = produce.value().isEmpty() ? produce.uri() : produce.value();
                this.setterInjection(method, bean, beanName, uri, produce.property());
            }
        }

        protected void setterPropertyInjection(Method method, String propertyValue, String propertyDefaultValue, Object bean, String beanName) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
            } else {
                String propertyName = org.apache.camel.util.ObjectHelper.getPropertyName((Method)method);
                Object value = this.getInjectionPropertyValue(parameterTypes[0], propertyValue, propertyDefaultValue, propertyName, bean, beanName);
                ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
            }
        }

        protected void setterBeanInjection(Method method, String name, Object bean, String beanName) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
            } else {
                Object value = this.getInjectionBeanValue(parameterTypes[0], name);
                ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
            }
        }

        protected void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointProperty) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
            } else {
                String propertyName = org.apache.camel.util.ObjectHelper.getPropertyName((Method)method);
                Object value = this.getInjectionValue(parameterTypes[0], endpointUri, endpointProperty, propertyName, bean, beanName);
                ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
            }
        }

        public Object afterInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
            LOG.trace("After init of bean: {} -> {}", (Object)beanName, bean);
            this.injectFields(bean, beanName);
            this.injectMethods(bean, beanName);
            return bean;
        }

        public void beforeDestroy(Object bean, String beanName) {
        }

        public void afterDestroy(Object bean, String beanName) {
        }

        protected boolean isSingleton(Object bean, String beanName) {
            String scope;
            ComponentMetadata meta;
            if (beanName != null && (meta = this.blueprintContainer.getComponentMetadata(beanName)) instanceof BeanMetadata && (scope = ((BeanMetadata)meta).getScope()) != null) {
                return "singleton".equals(scope);
            }
            return super.isSingleton(bean, beanName);
        }
    }

    public static class CamelDependenciesFinder
    implements ComponentDefinitionRegistryProcessor {
        private final String camelContextName;
        private final ParserContext context;
        private BlueprintContainer blueprintContainer;

        public CamelDependenciesFinder(String camelContextName, ParserContext context) {
            this.camelContextName = camelContextName;
            this.context = context;
        }

        public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
            this.blueprintContainer = blueprintContainer;
        }

        public void process(ComponentDefinitionRegistry componentDefinitionRegistry) {
            CamelContextFactoryBean ccfb = (CamelContextFactoryBean)((Object)this.blueprintContainer.getComponentInstance(".camelBlueprint.factory." + this.camelContextName));
            ModelCamelContext camelContext = ccfb.getContext();
            HashSet<String> components = new HashSet<String>();
            HashSet<String> languages = new HashSet<String>();
            HashSet<String> dataformats = new HashSet<String>();
            for (RouteDefinition rd : ((Model)camelContext.getExtension(Model.class)).getRouteDefinitions()) {
                this.findInputComponents(rd.getInput(), components, languages, dataformats);
                this.findOutputComponents(rd.getOutputs(), components, languages, dataformats);
            }
            for (RouteDefinition rd : ((Model)camelContext.getExtension(Model.class)).getRestDefinitions()) {
                for (VerbDefinition vd : rd.getVerbs()) {
                    ToDefinition to = vd.getTo();
                    if (to == null) continue;
                    this.findUriComponent(to.getUri(), components);
                }
            }
            if (ccfb.getRestConfiguration() != null) {
                String xml;
                Object component = ccfb.getRestConfiguration().getComponent();
                if (component != null) {
                    components.add((String)component);
                }
                if ((component = ccfb.getRestConfiguration().getApiComponent()) != null) {
                    components.add((String)component);
                }
                RestBindingMode mode = ccfb.getRestConfiguration().getBindingMode();
                String json = ccfb.getRestConfiguration().getJsonDataFormat();
                if (json == null && mode != null && (RestBindingMode.json.equals((Object)mode) || RestBindingMode.json_xml.equals((Object)mode))) {
                    json = "jackson";
                }
                if (json != null) {
                    dataformats.add(json);
                }
                if ((xml = ccfb.getRestConfiguration().getXmlDataFormat()) == null && mode != null && (RestBindingMode.xml.equals((Object)mode) || RestBindingMode.json_xml.equals((Object)mode))) {
                    dataformats.add("jaxb");
                }
                if (xml != null) {
                    dataformats.add(xml);
                }
            }
            try {
                for (String component : components) {
                    if (camelContext.getComponent(component, false) == null) {
                        CamelNamespaceHandler.getComponentResolverReference(this.context, component);
                        continue;
                    }
                    LOG.debug("Not creating a service reference for component {} because a component already exists in the Camel Context", (Object)component);
                }
                for (String language : languages) {
                    CamelNamespaceHandler.getLanguageResolverReference(this.context, language);
                }
                for (String dataformat : dataformats) {
                    CamelNamespaceHandler.getDataformatResolverReference(this.context, dataformat);
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to add dependencies to Camel components OSGi services. The Apache Aries blueprint implementation used is too old and the blueprint bundle cannot see the org.apache.camel.spi package.");
                components.clear();
                languages.clear();
                dataformats.clear();
            }
        }

        private void findInputComponents(FromDefinition from, Set<String> components, Set<String> languages, Set<String> dataformats) {
            if (from != null) {
                this.findUriComponent(from.getUri(), components);
                this.findSchedulerUriComponent(from.getUri(), components);
            }
        }

        private void findOutputComponents(List<ProcessorDefinition<?>> defs, Set<String> components, Set<String> languages, Set<String> dataformats) {
            if (defs != null) {
                for (ProcessorDefinition<?> def : defs) {
                    CatchDefinition doCatch;
                    if (def instanceof SendDefinition) {
                        this.findUriComponent(((SendDefinition)def).getUri(), components);
                    }
                    if (def instanceof MarshalDefinition) {
                        this.findDataFormat(((MarshalDefinition)def).getDataFormatType(), dataformats);
                    }
                    if (def instanceof UnmarshalDefinition) {
                        this.findDataFormat(((UnmarshalDefinition)def).getDataFormatType(), dataformats);
                    }
                    if (def instanceof ExpressionNode) {
                        this.findLanguage(((ExpressionNode)def).getExpression(), languages);
                    }
                    if (def instanceof ResequenceDefinition) {
                        this.findLanguage(((ResequenceDefinition)def).getExpression(), languages);
                    }
                    if (def instanceof AggregateDefinition) {
                        this.findLanguage(((AggregateDefinition)def).getExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCorrelationExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionPredicate(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionTimeoutExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionSizeExpression(), languages);
                    }
                    if (def instanceof CatchDefinition && (doCatch = (CatchDefinition)def).getOnWhen() != null) {
                        this.findLanguage(doCatch.getOnWhen().getExpression(), languages);
                    }
                    if (def instanceof OnExceptionDefinition) {
                        this.findLanguage(((OnExceptionDefinition)def).getRetryWhile(), languages);
                        this.findLanguage(((OnExceptionDefinition)def).getHandled(), languages);
                        this.findLanguage(((OnExceptionDefinition)def).getContinued(), languages);
                    }
                    if (def instanceof SortDefinition) {
                        this.findLanguage(((SortDefinition)def).getExpression(), languages);
                    }
                    this.findOutputComponents(def.getOutputs(), components, languages, dataformats);
                }
            }
        }

        private void findLanguage(ExpressionDefinition expression, Set<String> languages) {
            String lang;
            if (expression != null && (lang = expression.getLanguage()) != null && lang.length() > 0) {
                languages.add(lang);
            }
        }

        private void findLanguage(ExpressionSubElementDefinition expression, Set<String> languages) {
            if (expression != null) {
                this.findLanguage(expression.getExpressionType(), languages);
            }
        }

        private void findDataFormat(DataFormatDefinition dfd, Set<String> dataformats) {
            if (dfd != null && dfd.getDataFormatName() != null) {
                dataformats.add(dfd.getDataFormatName());
            }
        }

        private void findUriComponent(String uri, Set<String> components) {
            if (uri == null || uri.startsWith("{{")) {
                return;
            }
            if (!CamelDependenciesFinder.validateUri(uri)) {
                return;
            }
            String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
            if (splitURI[1] != null) {
                String scheme = splitURI[0];
                components.add(scheme);
            }
        }

        private void findSchedulerUriComponent(String uri, Set<String> components) {
            if (uri != null) {
                try {
                    URI u = new URI(uri);
                    Map parameters = URISupport.parseParameters((URI)u);
                    Object value = parameters.get("scheduler");
                    if (value != null) {
                        String name = value.toString();
                        if ("quartz".equals(name)) {
                            components.add("quartz");
                        } else if ("spring".equals(name)) {
                            components.add("spring-event");
                        }
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }

        private static boolean validateUri(String uri) {
            try {
                URISupport.normalizeUri((String)uri);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                LOG.error("Endpoint URI '" + uri + "' is not valid due to: " + e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

