/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="rest", displayName="Rest", description="Rest DSL Registry information")
public class RestDevConsole
extends AbstractDevConsole {
    public RestDevConsole() {
        super("camel", "rest", "Rest", "Rest DSL Registry information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        RestRegistry rr = this.getCamelContext().getRestRegistry();
        for (RestRegistry.RestService rs : rr.listAllRestServices()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("\n    Url: %s", rs.getUrl()));
            sb.append(String.format("\n    Method: %s", rs.getMethod()));
            sb.append(String.format("\n    State: %s", rs.getState()));
            if (rs.getConsumes() != null) {
                sb.append(String.format("\n    Consumes: %s", rs.getConsumes()));
            }
            if (rs.getProduces() != null) {
                sb.append(String.format("\n    Produces: %s", rs.getProduces()));
            }
            if (rs.getInType() != null) {
                sb.append(String.format("\n    In Type: %s", rs.getInType()));
            }
            if (rs.getOutType() != null) {
                sb.append(String.format("\n    Out Type: %s", rs.getOutType()));
            }
            if (rs.getDescription() == null) continue;
            sb.append(String.format("\n    Description: %s", rs.getDescription()));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put((Object)"rests", list);
        RestRegistry rr = this.getCamelContext().getRestRegistry();
        for (RestRegistry.RestService rs : rr.listAllRestServices()) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"url", (Object)rs.getUrl());
            jo.put((Object)"method", (Object)rs.getMethod());
            jo.put((Object)"contractFirst", (Object)rs.isContractFirst());
            jo.put((Object)"state", (Object)rs.getState());
            if (rs.getConsumes() != null) {
                jo.put((Object)"consumes", (Object)rs.getConsumes());
            }
            if (rs.getProduces() != null) {
                jo.put((Object)"produces", (Object)rs.getProduces());
            }
            if (rs.getInType() != null) {
                jo.put((Object)"inType", (Object)rs.getInType());
            }
            if (rs.getOutType() != null) {
                jo.put((Object)"outType", (Object)rs.getOutType());
            }
            if (rs.getDescription() != null) {
                jo.put((Object)"description", (Object)rs.getDescription());
            }
            list.add(jo);
        }
        return root;
    }
}

