/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.ConfigureDocLitWrapperInterceptor;
import org.apache.camel.component.cxf.interceptors.SetSoapVersionInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayLoadDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LoggerFactory.getLogger(PayLoadDataFormatFeature.class);
    private static final boolean DEFAULT_ALLOW_STREAMING;
    boolean allowStreaming = DEFAULT_ALLOW_STREAMING;

    public PayLoadDataFormatFeature() {
    }

    public PayLoadDataFormatFeature(Boolean streaming) {
        if (streaming != null) {
            this.allowStreaming = streaming;
        }
    }

    @Override
    public void initialize(Client client, Bus bus) {
        client.getEndpoint().put("org.apache.cxf.binding.soap.addNamespaceContext", "true");
        this.removeFaultInInterceptorFromClient(client);
        this.removeInterceptor(client.getEndpoint().getInInterceptors(), HolderInInterceptor.class);
        this.removeInterceptor(client.getEndpoint().getOutInterceptors(), HolderOutInterceptor.class);
        this.removeInterceptor(client.getEndpoint().getBinding().getInInterceptors(), SoapHeaderInterceptor.class);
        client.getEndpoint().getBinding().getInInterceptors().add(new ConfigureDocLitWrapperInterceptor(true));
        this.resetPartTypes(client.getEndpoint().getBinding());
        LOG.info("Initialized CXF Client: {} in Payload mode with allow streaming: {}", (Object)client, (Object)this.allowStreaming);
    }

    @Override
    public void initialize(Server server, Bus bus) {
        server.getEndpoint().put("org.apache.cxf.binding.soap.addNamespaceContext", "true");
        server.getEndpoint().getBinding().getInInterceptors().add(new ConfigureDocLitWrapperInterceptor(true));
        if (server.getEndpoint().getBinding() instanceof SoapBinding) {
            server.getEndpoint().getBinding().getOutInterceptors().add(new SetSoapVersionInterceptor());
        }
        this.removeInterceptor(server.getEndpoint().getInInterceptors(), HolderInInterceptor.class);
        this.removeInterceptor(server.getEndpoint().getOutInterceptors(), HolderOutInterceptor.class);
        this.removeInterceptor(server.getEndpoint().getBinding().getInInterceptors(), SoapHeaderInterceptor.class);
        this.resetPartTypes(server.getEndpoint().getBinding());
        LOG.info("Initialized CXF Server: {} in Payload mode with allow streaming: {}", (Object)server, (Object)this.allowStreaming);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    private void resetPartTypes(Binding bop2) {
        for (BindingOperationInfo bop : bop2.getBindingInfo().getOperations()) {
            this.resetPartTypes(bop);
        }
    }

    private void resetPartTypes(BindingOperationInfo bop) {
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop.isUnwrappedCapable()) {
            this.resetPartTypeClass(bop.getWrappedOperation().getOperationInfo().getInput());
            this.resetPartTypeClass(bop.getWrappedOperation().getOperationInfo().getOutput());
            this.resetPartTypeClass(bop.getWrappedOperation().getInput());
            this.resetPartTypeClass(bop.getWrappedOperation().getOutput());
        } else {
            this.resetPartTypeClass(bop.getOperationInfo().getInput());
            this.resetPartTypeClass(bop.getOperationInfo().getOutput());
            this.resetPartTypeClass(bop.getInput());
            this.resetPartTypeClass(bop.getOutput());
        }
    }

    protected void resetPartTypeClass(BindingMessageInfo bmi) {
        if (bmi != null) {
            int size = bmi.getMessageParts().size();
            for (int x = 0; x < size; ++x) {
                if (x < size - 1) {
                    bmi.getMessageParts().get(x).setTypeClass(this.allowStreaming ? DOMSource.class : null);
                    continue;
                }
                bmi.getMessageParts().get(x).setTypeClass(this.allowStreaming ? Source.class : null);
            }
        }
    }

    protected void resetPartTypeClass(MessageInfo msgInfo) {
        if (msgInfo != null) {
            int size = msgInfo.getMessageParts().size();
            for (int x = 0; x < size; ++x) {
                if (x < size - 1) {
                    msgInfo.getMessageParts().get(x).setTypeClass(this.allowStreaming ? DOMSource.class : null);
                    continue;
                }
                msgInfo.getMessageParts().get(x).setTypeClass(this.allowStreaming ? Source.class : null);
            }
        }
    }

    static {
        String s = System.getProperty("org.apache.camel.component.cxf.streaming");
        DEFAULT_ALLOW_STREAMING = s == null || Boolean.parseBoolean(s);
    }
}

