/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class RawMessageContentRedirectInterceptor
extends AbstractPhaseInterceptor<Message> {
    public RawMessageContentRedirectInterceptor() {
        super("write");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        List params;
        Throwable ex = message.getContent(Throwable.class);
        if (ex != null) {
            RawMessageContentRedirectInterceptor.throwFault(ex);
        }
        if (null != (params = message.getContent(List.class))) {
            OutputStream os = message.getContent(OutputStream.class);
            Writer writer = message.getContent(Writer.class);
            if (os == null && writer == null) {
                return;
            }
            InputStream is = (InputStream)params.get(0);
            RawMessageContentRedirectInterceptor.tryIO(os, writer, is);
        }
    }

    private static void tryIO(OutputStream os, Writer writer, InputStream is) {
        try {
            if (os == null && writer != null) {
                IOUtils.copyAndCloseInput(new InputStreamReader(is), writer);
            } else if (is instanceof StreamCache) {
                ((StreamCache)is).writeTo(os);
            } else {
                IOUtils.copy(is, os);
            }
        }
        catch (Exception e) {
            throw new Fault(e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)"input stream", null);
        }
    }

    private static void throwFault(Throwable ex) {
        if (ex instanceof Fault) {
            throw (Fault)ex;
        }
        throw new Fault(ex);
    }
}

