/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.annotation.Annotation;
import javax.xml.namespace.QName;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CxfRsEndpointUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsEndpointUtils.class);

    private CxfRsEndpointUtils() {
    }

    public static QName getQName(String name) {
        QName qName = null;
        if (name != null) {
            try {
                qName = QName.valueOf(name);
            }
            catch (Exception ex) {
                LOG.warn("Cannot create QName: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return qName;
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls == null || cls == Object.class) {
            return false;
        }
        if (null != cls.getAnnotation(annotation)) {
            return true;
        }
        for (Class<?> interfaceClass : cls.getInterfaces()) {
            if (null == interfaceClass.getAnnotation(annotation)) continue;
            return true;
        }
        return CxfRsEndpointUtils.hasAnnotation(cls.getSuperclass(), annotation);
    }

    public static void checkServiceClassName(String className) throws CamelException {
        if (ObjectHelper.isEmpty((String)className)) {
            throw new CamelException("serviceClass is required for CXF endpoint configuration");
        }
    }

    public static String getEffectiveAddress(Exchange exchange, String defaultAddress) {
        String retval = (String)exchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (retval == null) {
            retval = defaultAddress;
        } else {
            LOG.trace("Client address is overridden by header '{}' to value '{}'", (Object)"CamelDestinationOverrideUrl", (Object)retval);
        }
        return retval;
    }
}

