/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport.message;

import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.common.header.CxfHeaderHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;

public final class CxfMessageHelper {
    private CxfMessageHelper() {
    }

    public static org.apache.cxf.message.Message getCxfInMessage(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, boolean isClient) {
        MessageImpl answer = new MessageImpl();
        org.apache.cxf.message.Exchange cxfExchange = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        Message message = isClient ? exchange.getMessage() : exchange.getIn();
        ObjectHelper.notNull((Object)message, (String)"message");
        if (cxfExchange == null) {
            cxfExchange = new ExchangeImpl();
            exchange.setProperty("org.apache.cxf.message.exchange", (Object)cxfExchange);
        }
        CxfHeaderHelper.propagateCamelToCxf(headerFilterStrategy, message.getHeaders(), answer, exchange);
        InputStream body = (InputStream)message.getBody(InputStream.class);
        if (body != null) {
            answer.setContent(InputStream.class, body);
        } else if (message.getBody() != null) {
            answer.setContent(Object.class, body);
        }
        answer.putAll(message.getHeaders());
        answer.setExchange(cxfExchange);
        cxfExchange.setInMessage(answer);
        return answer;
    }
}

