/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class HttpHeadersImpl
implements HttpHeaders {
    static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    static final String COOKIE_SEPARATOR_PROPERTY = "org.apache.cxf.http.cookie.separator";
    private static final String COOKIE_SEPARATOR_CRLF = "crlf";
    private static final String COOKIE_SEPARATOR_CRLF_EXPRESSION = "\r\n";
    private static final Pattern COOKIE_SEPARATOR_CRLF_PATTERN = Pattern.compile("\r\n");
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String DEFAULT_COOKIE_SEPARATOR = ";";
    private static final String DOLLAR_CHAR = "$";
    private static final String COOKIE_VERSION_PARAM = "$Version";
    private static final String COOKIE_PATH_PARAM = "$Path";
    private static final String COOKIE_DOMAIN_PARAM = "$Domain";
    private static final String COMPLEX_HEADER_EXPRESSION = "(([\\w]+=\"[^\"]*\")|([\\w]+=[\\w]+)|([\\w]+))(;(([\\w]+=\"[^\"]*\")|([\\w]+=[\\w]+)|([\\w]+)))?";
    private static final Pattern COMPLEX_HEADER_PATTERN = Pattern.compile("(([\\w]+=\"[^\"]*\")|([\\w]+=[\\w]+)|([\\w]+))(;(([\\w]+=\"[^\"]*\")|([\\w]+=[\\w]+)|([\\w]+)))?");
    private static final String QUOTE = "\"";
    private static final Set<String> HEADERS_WITH_POSSIBLE_QUOTES = new HashSet<String>();
    private Message message;
    private Map<String, List<String>> headers;

    public HttpHeadersImpl(Message message) {
        this.message = message;
        this.headers = HttpHeadersImpl.filter(CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS)));
    }

    private static Map<String, List<String>> filter(Map<String, List<String>> protocolHeaders) {
        if (protocolHeaders == null) {
            return Collections.emptyMap();
        }
        if (protocolHeaders.isEmpty()) {
            return protocolHeaders;
        }
        Set nullableHeader = protocolHeaders.entrySet().stream().filter(e -> {
            if (e.getValue() == null) {
                return true;
            }
            if (((List)e.getValue()).size() == 1) {
                return ((List)e.getValue()).get(0) == null;
            }
            return false;
        }).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        if (nullableHeader.isEmpty()) {
            return protocolHeaders;
        }
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> entry : protocolHeaders.entrySet()) {
            if (nullableHeader.contains(entry.getKey())) continue;
            headers.put(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List<String> lValues = this.headers.get("Accept");
        if (lValues == null || lValues.isEmpty() || lValues.get(0) == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        LinkedList<MediaType> mediaTypes = new LinkedList<MediaType>();
        for (String value : lValues) {
            mediaTypes.addAll(JAXRSUtils.parseMediaTypes(value));
        }
        this.sortMediaTypesUsingQualityFactor(mediaTypes);
        return mediaTypes;
    }

    public Map<String, Cookie> getCookies() {
        List<String> values = this.headers.get("Cookie");
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> cl = new HashMap<String, Cookie>();
        for (String value : values) {
            if (value == null) continue;
            List<String> cs = HttpHeadersImpl.getHeaderValues("Cookie", value, this.getCookieSeparator(value));
            for (String c : cs) {
                Cookie cookie = Cookie.valueOf((String)c);
                cl.put(cookie.getName(), cookie);
            }
        }
        return cl;
    }

    private String getCookieSeparator(String value) {
        String separator = this.getCookieSeparatorFromProperty();
        if (separator != null) {
            return separator;
        }
        if (value.contains(DOLLAR_CHAR) && (value.contains(COOKIE_VERSION_PARAM) || value.contains(COOKIE_PATH_PARAM) || value.contains(COOKIE_DOMAIN_PARAM))) {
            return DEFAULT_SEPARATOR;
        }
        return DEFAULT_COOKIE_SEPARATOR;
    }

    private String getCookieSeparatorFromProperty() {
        Object cookiePropValue = this.message.getContextualProperty(COOKIE_SEPARATOR_PROPERTY);
        if (cookiePropValue != null) {
            String separator = cookiePropValue.toString().trim();
            if (COOKIE_SEPARATOR_CRLF.equals(separator)) {
                return COOKIE_SEPARATOR_CRLF_EXPRESSION;
            }
            if (separator.length() != 1) {
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            return separator;
        }
        return null;
    }

    public Locale getLanguage() {
        List<String> values = this.getListValues("Content-Language");
        return values.isEmpty() ? null : HttpUtils.getLocale(values.get(0).trim());
    }

    public MediaType getMediaType() {
        List<String> values = this.getListValues("Content-Type");
        return values.isEmpty() ? null : JAXRSUtils.toMediaType(values.get(0));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        boolean splitIndividualValue = MessageUtils.getContextualBoolean(this.message, HEADER_SPLIT_PROPERTY, false);
        if (splitIndividualValue) {
            TreeMap<String, List<String>> newHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                newHeaders.put(entry.getKey(), this.getRequestHeader(entry.getKey()));
            }
            return new MetadataMap<String, String>(Collections.unmodifiableMap(newHeaders), false);
        }
        return new MetadataMap<String, String>(Collections.unmodifiableMap(this.headers), false);
    }

    public List<Locale> getAcceptableLanguages() {
        List<String> ls = this.getListValues("Accept-Language");
        if (ls.isEmpty()) {
            return Collections.singletonList(new Locale("*"));
        }
        ArrayList<Locale> newLs = new ArrayList<Locale>();
        HashMap<Locale, Float> prefs = new HashMap<Locale, Float>();
        for (String l : ls) {
            String[] pair = l.split(DEFAULT_COOKIE_SEPARATOR);
            Locale locale = HttpUtils.getLocale(pair[0].trim());
            newLs.add(locale);
            if (pair.length > 1) {
                String[] pair2 = pair[1].split("=");
                if (pair2.length > 1) {
                    prefs.put(locale, Float.valueOf(JAXRSUtils.getMediaTypeQualityFactor(pair2[1].trim())));
                    continue;
                }
                prefs.put(locale, Float.valueOf(1.0f));
                continue;
            }
            prefs.put(locale, Float.valueOf(1.0f));
        }
        if (newLs.size() <= 1) {
            return newLs;
        }
        Collections.sort(newLs, new AcceptLanguageComparator(prefs));
        return newLs;
    }

    public List<String> getRequestHeader(String name) {
        boolean splitIndividualValue = MessageUtils.getContextualBoolean(this.message, HEADER_SPLIT_PROPERTY, false);
        List<String> values = this.headers.get(name);
        if (!splitIndividualValue || values == null || HttpUtils.isDateRelatedHeader(name)) {
            return values;
        }
        LinkedList<String> ls = new LinkedList<String>();
        for (String value : values) {
            if (value == null) continue;
            String sep = "Cookie".equalsIgnoreCase(name) ? this.getCookieSeparator(value) : DEFAULT_SEPARATOR;
            ls.addAll(HttpHeadersImpl.getHeaderValues(name, value, sep));
        }
        return ls;
    }

    private List<String> getListValues(String headerName) {
        List<String> values = this.headers.get(headerName);
        if (values == null || values.isEmpty() || values.get(0) == null) {
            return Collections.emptyList();
        }
        if (HttpUtils.isDateRelatedHeader(headerName)) {
            return values;
        }
        LinkedList<String> actualValues = new LinkedList<String>();
        for (String v : values) {
            actualValues.addAll(this.getHeaderValues(headerName, v));
        }
        return actualValues;
    }

    private List<String> getHeaderValues(String headerName, String originalValue) {
        return HttpHeadersImpl.getHeaderValues(headerName, originalValue, DEFAULT_SEPARATOR);
    }

    private static List<String> getHeaderValues(String headerName, String originalValue, String sep) {
        if (!originalValue.contains(QUOTE) || HEADERS_WITH_POSSIBLE_QUOTES.contains(headerName)) {
            String[] ls = !COOKIE_SEPARATOR_CRLF_EXPRESSION.equals(sep) ? originalValue.split(sep) : COOKIE_SEPARATOR_CRLF_PATTERN.split(originalValue);
            if (ls.length == 1) {
                return Collections.singletonList(ls[0].trim());
            }
            ArrayList<String> newValues = new ArrayList<String>();
            for (String v : ls) {
                newValues.add(v.trim());
            }
            return newValues;
        }
        if (originalValue.startsWith(QUOTE) && originalValue.endsWith(QUOTE)) {
            String actualValue = originalValue.length() == 2 ? "" : originalValue.substring(1, originalValue.length() - 1);
            return Collections.singletonList(actualValue);
        }
        ArrayList<String> values = new ArrayList<String>(4);
        Matcher m = COMPLEX_HEADER_PATTERN.matcher(originalValue);
        while (m.find()) {
            String val = m.group().trim();
            if (val.length() <= 0) continue;
            values.add(val);
        }
        return values;
    }

    private void sortMediaTypesUsingQualityFactor(List<MediaType> types) {
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2);
                }
            });
        }
    }

    public Date getDate() {
        List<String> values = this.headers.get("Date");
        if (values == null || values.isEmpty() || StringUtils.isEmpty(values.get(0))) {
            return null;
        }
        return HttpUtils.getHttpDate(values.get(0));
    }

    public String getHeaderString(String headerName) {
        return HttpUtils.getHeaderString(this.headers.get(headerName));
    }

    public int getLength() {
        List<String> values = this.headers.get("Content-Length");
        if (values == null || values.size() != 1) {
            return -1;
        }
        return HttpUtils.getContentLength(values.get(0));
    }

    static {
        HEADERS_WITH_POSSIBLE_QUOTES.add("Content-Type");
        HEADERS_WITH_POSSIBLE_QUOTES.add("Cache-Control");
        HEADERS_WITH_POSSIBLE_QUOTES.add("ETag");
        HEADERS_WITH_POSSIBLE_QUOTES.add("If-Match");
        HEADERS_WITH_POSSIBLE_QUOTES.add("If-None-Match");
        HEADERS_WITH_POSSIBLE_QUOTES.add("Cookie");
        HEADERS_WITH_POSSIBLE_QUOTES.add("Set-Cookie");
    }

    private static class AcceptLanguageComparator
    implements Comparator<Locale> {
        private Map<Locale, Float> prefs;

        AcceptLanguageComparator(Map<Locale, Float> prefs) {
            this.prefs = prefs;
        }

        @Override
        public int compare(Locale lang1, Locale lang2) {
            float p1 = this.prefs.get(lang1).floatValue();
            float p2 = this.prefs.get(lang2).floatValue();
            return Float.compare(p1, p2) * -1;
        }
    }
}

