/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

public class PerRequestResourceProvider
implements ResourceProvider {
    private Constructor<?> c;
    private Method postConstructMethod;
    private Method preDestroyMethod;
    private final Class<?>[] params;
    private final Annotation[][] anns;
    private final Type[] genericTypes;

    public PerRequestResourceProvider(Class<?> clazz) {
        this.c = ResourceUtils.findResourceConstructor(clazz, true);
        if (this.c == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
        this.params = this.c.getParameterTypes();
        this.anns = this.c.getParameterAnnotations();
        this.genericTypes = this.c.getGenericParameterTypes();
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object getInstance(Message m) {
        return this.createInstance(m);
    }

    protected Object createInstance(Message m) {
        ProviderInfo application = (ProviderInfo)m.getExchange().getEndpoint().get(Application.class.getName());
        Map<Class<?>, Object> mapValues = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m, true, mapValues, this.params, this.anns, this.genericTypes);
        try {
            Object instance = values.length > 0 ? this.c.newInstance(values) : this.c.newInstance(new Object[0]);
            InjectionUtils.invokeLifeCycleMethod(instance, this.postConstructMethod);
            return instance;
        }
        catch (InstantiationException ex) {
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
        catch (IllegalAccessException ex) {
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated due to IllegalAccessException";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
        catch (InvocationTargetException ex) {
            Response r = JAXRSUtils.convertFaultToResponse(ex.getCause(), m);
            if (r != null) {
                m.getExchange().put(Response.class, r);
                throw new WebApplicationException();
            }
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated due to InvocationTargetException";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
    }

    private Response serverError(String msg) {
        return JAXRSUtils.toResponseBuilder(500).entity((Object)msg).build();
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
    }

    @Override
    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }
}

