/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.w3c.dom.Element;

public class SOAPMessageContextImpl
extends WrappedMessageContext
implements SOAPMessageContext {
    private static final SAAJInInterceptor SAAJ_IN = new SAAJInInterceptor();
    private Set<String> roles = new HashSet<String>();

    public SOAPMessageContextImpl(Message m) {
        super(m, MessageContext.Scope.HANDLER);
        this.roles.add(this.getWrappedSoapMessage().getVersion().getNextRole());
    }

    public void setMessage(SOAPMessage message) {
        if (this.getWrappedMessage().getContent(Object.class) instanceof SOAPMessage) {
            this.getWrappedMessage().setContent(Object.class, message);
        } else {
            this.getWrappedMessage().setContent(SOAPMessage.class, message);
        }
    }

    public SOAPMessage getMessage() {
        Boolean outboundProperty;
        SOAPMessage message = this.getWrappedMessage().getContent(Object.class) instanceof SOAPMessage ? (SOAPMessage)this.getWrappedMessage().getContent(Object.class) : this.getWrappedMessage().getContent(SOAPMessage.class);
        if (!(null != message || (outboundProperty = (Boolean)this.get("jakarta.xml.ws.handler.message.outbound")) != null && outboundProperty.booleanValue())) {
            SAAJ_IN.handleMessage(this.getWrappedSoapMessage());
            message = this.getWrappedSoapMessage().getContent(SOAPMessage.class);
        }
        return message;
    }

    public Object[] getHeaders(QName name, JAXBContext context, boolean allRoles) {
        SOAPMessage msg = this.getMessage();
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null || !header.hasChildNodes()) {
                return new Object[0];
            }
            ArrayList<Object> ret = new ArrayList<Object>();
            Iterator it = CastUtils.cast(header.examineAllHeaderElements());
            while (it.hasNext()) {
                SOAPHeaderElement she = (SOAPHeaderElement)it.next();
                if (!allRoles && !this.roles.contains(she.getActor()) || !name.equals(she.getElementQName())) continue;
                ret.add(JAXBUtils.unmarshall(context, (Element)she));
            }
            return ret.toArray(new Object[0]);
        }
        catch (JAXBException | SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    private SoapMessage getWrappedSoapMessage() {
        return (SoapMessage)this.getWrappedMessage();
    }

    @Override
    public Object get(Object key) {
        Map mp;
        Object o = super.get(key);
        if (("jakarta.xml.ws.http.response.headers".equals(key) || "jakarta.xml.ws.http.request.headers".equals(key)) && (mp = (Map)o) != null) {
            if (mp.isEmpty()) {
                return null;
            }
            if (!this.isRequestor() && this.isOutbound() && "jakarta.xml.ws.http.response.headers".equals(key)) {
                return null;
            }
            if (this.isRequestor() && !this.isOutbound() && "jakarta.xml.ws.http.request.headers".equals(key)) {
                return null;
            }
        }
        return o;
    }
}

