/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.blueprint.jaxrs;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.component.cxf.blueprint.helpers.BlueprintSupport;
import org.apache.camel.component.cxf.blueprint.helpers.RsClientBlueprintBean;
import org.apache.camel.component.cxf.blueprint.helpers.RsServerBlueprintBean;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.util.ReflectionHelper;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class CxfRsBlueprintEndpoint
extends CxfRsEndpoint {
    private AbstractJAXRSFactoryBean bean;
    private BlueprintContainer blueprintContainer;
    private BundleContext bundleContext;
    private BlueprintCamelContext blueprintCamelContext;

    public CxfRsBlueprintEndpoint(Component comp, String uri, AbstractJAXRSFactoryBean bean) {
        super(uri, comp);
        this.bean = bean;
        this.setAddress(bean.getAddress());
        bean.setAddress(this.getAddress());
        BlueprintSupport support = (BlueprintSupport)bean;
        this.setBlueprintContainer(support.getBlueprintContainer());
        this.setBundleContext(support.getBundleContext());
    }

    protected void doInit() throws Exception {
        if (this.getCamelContext() == null) {
            this.setCamelContext((CamelContext)this.blueprintCamelContext);
        }
        super.doInit();
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintCamelContext getBlueprintCamelContext() {
        return this.blueprintCamelContext;
    }

    public void setBlueprintCamelContext(BlueprintCamelContext blueprintCamelContext) {
        this.blueprintCamelContext = blueprintCamelContext;
    }

    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        this.checkBeanType(this.bean, JAXRSServerFactoryBean.class);
        return (RsServerBlueprintBean)this.bean;
    }

    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        this.checkBeanType(this.bean, JAXRSClientFactoryBean.class);
        return this.newInstanceWithCommonProperties();
    }

    private RsClientBlueprintBean newInstanceWithCommonProperties() {
        RsClientBlueprintBean cfb = new RsClientBlueprintBean();
        if (this.bean instanceof RsClientBlueprintBean) {
            CxfRsBlueprintEndpoint.shallowCopyFieldState(this.bean, cfb);
        }
        return cfb;
    }

    private static void shallowCopyFieldState(Object src, Object dest) {
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionHelper.doWithFields(src.getClass(), field -> {
            if (CxfRsBlueprintEndpoint.isCopyableField(field)) {
                CxfRsBlueprintEndpoint.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        });
    }

    private static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    private static boolean isCopyableField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }
}

