/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.Mapper;
import com.datasonnet.document.MediaType;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.datasonnet.DatasonnetExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="datasonnet")
public class DatasonnetLanguage
extends SingleInputTypedLanguageSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DatasonnetLanguage.class);
    private static final Map<String, String> CLASSPATH_IMPORTS = new HashMap<String, String>();
    private final Map<String, Mapper> mapperCache = LRUCacheFactory.newLRUSoftCache((int)16, (int)1000, (boolean)true);

    public Predicate createPredicate(String expression) {
        return this.createPredicate(expression, null);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return (Predicate)this.createExpression(expression, properties);
    }

    public Expression createExpression(Expression source, String expression, Object[] properties) {
        expression = this.loadResource(expression);
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        answer.setSource(source);
        answer.setResultType((Class)this.property(Class.class, properties, 0, null));
        String mediaType = (String)this.property(String.class, properties, 2, null);
        if (mediaType != null) {
            answer.setBodyMediaType(MediaType.valueOf((String)mediaType));
        }
        if ((mediaType = (String)this.property(String.class, properties, 3, null)) != null) {
            answer.setOutputMediaType(MediaType.valueOf((String)mediaType));
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    Optional<Mapper> lookup(String script) {
        return Optional.ofNullable(this.mapperCache.get(script));
    }

    Mapper computeIfMiss(String script, Supplier<Mapper> mapperSupplier) {
        return this.mapperCache.computeIfAbsent(script, k -> (Mapper)mapperSupplier.get());
    }

    public Map<String, String> getClasspathImports() {
        return CLASSPATH_IMPORTS;
    }

    static {
        LOG.debug("One time classpath search...");
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"/"}).scan();){
            try {
                scanResult.getResourcesWithExtension("libsonnet").forEachByteArrayThrowingIOException((resource, bytes) -> {
                    LOG.debug("Loading DataSonnet library: {}", (Object)resource.getPath());
                    CLASSPATH_IMPORTS.put(resource.getPath(), new String(bytes, StandardCharsets.UTF_8));
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.debug("One time classpath search done");
    }
}

