/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MongoDbConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mongodb";
    @UriParam(label="consumer,mongodb", defaultValue="io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory")
    private String transactionMetadataFactory = "io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private long streamingDelayMs = 0L;
    @UriParam(label="consumer,mongodb")
    private String customMetricTags;
    @UriParam(label="consumer,mongodb")
    private String mongodbConnectionString;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbPassword;
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,mongodb", defaultValue="source")
    private String signalEnabledChannels = "source";
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslEnabled = false;
    @UriParam(label="consumer,mongodb", javaType="java.time.Duration")
    private int cursorMaxAwaitTimeMs;
    @UriParam(label="consumer,mongodb")
    private String fieldRenames;
    @UriParam(label="consumer,mongodb", defaultValue="30s", javaType="java.time.Duration")
    private int mongodbServerSelectionTimeoutMs = 30000;
    @UriParam(label="consumer,mongodb", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,mongodb")
    private String signalDataCollection;
    @UriParam(label="consumer,mongodb")
    private String converters;
    @UriParam(label="consumer,mongodb", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,mongodb", defaultValue="10s", javaType="java.time.Duration")
    private int mongodbConnectTimeoutMs = 10000;
    @UriParam(label="consumer,mongodb")
    private int snapshotFetchSize;
    @UriParam(label="consumer,mongodb", defaultValue="30s", javaType="java.time.Duration")
    private long mongodbPollIntervalMs = 30000L;
    @UriParam(label="consumer,mongodb", defaultValue="INSERT_INSERT")
    private String incrementalSnapshotWatermarkingStrategy = "INSERT_INSERT";
    @UriParam(label="consumer,mongodb")
    private String mongodbUser;
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnSchemaError = false;
    @UriParam(label="consumer,mongodb")
    private String snapshotCollectionFilterOverrides;
    @UriParam(label="consumer,mongodb")
    private String fieldExcludeList;
    @UriParam(label="consumer,mongodb", defaultValue="-1")
    private int errorsMaxRetries = -1;
    @UriParam(label="consumer,mongodb")
    private String databaseExcludeList;
    @UriParam(label="consumer,mongodb", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mongodb", defaultValue="t")
    private String skippedOperations = "t";
    @UriParam(label="consumer,mongodb", defaultValue="io.debezium.schema.SchemaTopicNamingStrategy")
    private String topicNamingStrategy = "io.debezium.schema.SchemaTopicNamingStrategy";
    @UriParam(label="consumer,mongodb", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotData = false;
    @UriParam(label="consumer,mongodb", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mongodb")
    private String collectionIncludeList;
    @UriParam(label="consumer,mongodb", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,mongodb", defaultValue="change_streams_update_full")
    private String captureMode = "change_streams_update_full";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnDataError = false;
    @UriParam(label="consumer,mongodb")
    private String schemaHistoryInternalFileFilename;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String topicPrefix;
    @UriParam(label="consumer,mongodb", defaultValue="io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker")
    private String sourceinfoStructMaker = "io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker";
    @UriParam(label="consumer,mongodb", defaultValue="admin")
    private String mongodbAuthsource = "admin";
    @UriParam(label="consumer,mongodb")
    private String collectionExcludeList;
    @UriParam(label="consumer,mongodb")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean snapshotModeConfigurationBasedStartStream = false;
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotSchema = false;
    @UriParam(label="consumer,mongodb", defaultValue="5s", javaType="java.time.Duration")
    private long signalPollIntervalMs = 5000L;
    @UriParam(label="consumer,mongodb")
    private String postProcessors;
    @UriParam(label="consumer,mongodb")
    private String notificationEnabledChannels;
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private int mongodbSocketTimeoutMs = 0;
    @UriParam(label="consumer,mongodb", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,mongodb", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,mongodb")
    private String notificationSinkTopicName;
    @UriParam(label="consumer,mongodb")
    private String snapshotModeCustomName;
    @UriParam(label="consumer,mongodb", defaultValue="none")
    private String schemaNameAdjustmentMode = "none";
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslInvalidHostnameAllowed = false;
    @UriParam(label="consumer,mongodb", defaultValue="10s", javaType="java.time.Duration")
    private int mongodbHeartbeatFrequencyMs = 10000;
    @UriParam(label="consumer,mongodb")
    private String databaseIncludeList;

    public void setTransactionMetadataFactory(String transactionMetadataFactory) {
        this.transactionMetadataFactory = transactionMetadataFactory;
    }

    public String getTransactionMetadataFactory() {
        return this.transactionMetadataFactory;
    }

    public void setStreamingDelayMs(long streamingDelayMs) {
        this.streamingDelayMs = streamingDelayMs;
    }

    public long getStreamingDelayMs() {
        return this.streamingDelayMs;
    }

    public void setCustomMetricTags(String customMetricTags) {
        this.customMetricTags = customMetricTags;
    }

    public String getCustomMetricTags() {
        return this.customMetricTags;
    }

    public void setMongodbConnectionString(String mongodbConnectionString) {
        this.mongodbConnectionString = mongodbConnectionString;
    }

    public String getMongodbConnectionString() {
        return this.mongodbConnectionString;
    }

    public void setMongodbPassword(String mongodbPassword) {
        this.mongodbPassword = mongodbPassword;
    }

    public String getMongodbPassword() {
        return this.mongodbPassword;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setSignalEnabledChannels(String signalEnabledChannels) {
        this.signalEnabledChannels = signalEnabledChannels;
    }

    public String getSignalEnabledChannels() {
        return this.signalEnabledChannels;
    }

    public void setMongodbSslEnabled(boolean mongodbSslEnabled) {
        this.mongodbSslEnabled = mongodbSslEnabled;
    }

    public boolean isMongodbSslEnabled() {
        return this.mongodbSslEnabled;
    }

    public void setCursorMaxAwaitTimeMs(int cursorMaxAwaitTimeMs) {
        this.cursorMaxAwaitTimeMs = cursorMaxAwaitTimeMs;
    }

    public int getCursorMaxAwaitTimeMs() {
        return this.cursorMaxAwaitTimeMs;
    }

    public void setFieldRenames(String fieldRenames) {
        this.fieldRenames = fieldRenames;
    }

    public String getFieldRenames() {
        return this.fieldRenames;
    }

    public void setMongodbServerSelectionTimeoutMs(int mongodbServerSelectionTimeoutMs) {
        this.mongodbServerSelectionTimeoutMs = mongodbServerSelectionTimeoutMs;
    }

    public int getMongodbServerSelectionTimeoutMs() {
        return this.mongodbServerSelectionTimeoutMs;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setMongodbConnectTimeoutMs(int mongodbConnectTimeoutMs) {
        this.mongodbConnectTimeoutMs = mongodbConnectTimeoutMs;
    }

    public int getMongodbConnectTimeoutMs() {
        return this.mongodbConnectTimeoutMs;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setMongodbPollIntervalMs(long mongodbPollIntervalMs) {
        this.mongodbPollIntervalMs = mongodbPollIntervalMs;
    }

    public long getMongodbPollIntervalMs() {
        return this.mongodbPollIntervalMs;
    }

    public void setIncrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
        this.incrementalSnapshotWatermarkingStrategy = incrementalSnapshotWatermarkingStrategy;
    }

    public String getIncrementalSnapshotWatermarkingStrategy() {
        return this.incrementalSnapshotWatermarkingStrategy;
    }

    public void setMongodbUser(String mongodbUser) {
        this.mongodbUser = mongodbUser;
    }

    public String getMongodbUser() {
        return this.mongodbUser;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
        this.snapshotModeConfigurationBasedSnapshotOnSchemaError = snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnSchemaError() {
        return this.snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public void setSnapshotCollectionFilterOverrides(String snapshotCollectionFilterOverrides) {
        this.snapshotCollectionFilterOverrides = snapshotCollectionFilterOverrides;
    }

    public String getSnapshotCollectionFilterOverrides() {
        return this.snapshotCollectionFilterOverrides;
    }

    public void setFieldExcludeList(String fieldExcludeList) {
        this.fieldExcludeList = fieldExcludeList;
    }

    public String getFieldExcludeList() {
        return this.fieldExcludeList;
    }

    public void setErrorsMaxRetries(int errorsMaxRetries) {
        this.errorsMaxRetries = errorsMaxRetries;
    }

    public int getErrorsMaxRetries() {
        return this.errorsMaxRetries;
    }

    public void setDatabaseExcludeList(String databaseExcludeList) {
        this.databaseExcludeList = databaseExcludeList;
    }

    public String getDatabaseExcludeList() {
        return this.databaseExcludeList;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setTopicNamingStrategy(String topicNamingStrategy) {
        this.topicNamingStrategy = topicNamingStrategy;
    }

    public String getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setSnapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
        this.snapshotModeConfigurationBasedSnapshotData = snapshotModeConfigurationBasedSnapshotData;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotData() {
        return this.snapshotModeConfigurationBasedSnapshotData;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setCollectionIncludeList(String collectionIncludeList) {
        this.collectionIncludeList = collectionIncludeList;
    }

    public String getCollectionIncludeList() {
        return this.collectionIncludeList;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setCaptureMode(String captureMode) {
        this.captureMode = captureMode;
    }

    public String getCaptureMode() {
        return this.captureMode;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
        this.snapshotModeConfigurationBasedSnapshotOnDataError = snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnDataError() {
        return this.snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public void setSchemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
        this.schemaHistoryInternalFileFilename = schemaHistoryInternalFileFilename;
    }

    public String getSchemaHistoryInternalFileFilename() {
        return this.schemaHistoryInternalFileFilename;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setSourceinfoStructMaker(String sourceinfoStructMaker) {
        this.sourceinfoStructMaker = sourceinfoStructMaker;
    }

    public String getSourceinfoStructMaker() {
        return this.sourceinfoStructMaker;
    }

    public void setMongodbAuthsource(String mongodbAuthsource) {
        this.mongodbAuthsource = mongodbAuthsource;
    }

    public String getMongodbAuthsource() {
        return this.mongodbAuthsource;
    }

    public void setCollectionExcludeList(String collectionExcludeList) {
        this.collectionExcludeList = collectionExcludeList;
    }

    public String getCollectionExcludeList() {
        return this.collectionExcludeList;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setSnapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
        this.snapshotModeConfigurationBasedStartStream = snapshotModeConfigurationBasedStartStream;
    }

    public boolean isSnapshotModeConfigurationBasedStartStream() {
        return this.snapshotModeConfigurationBasedStartStream;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setSnapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
        this.snapshotModeConfigurationBasedSnapshotSchema = snapshotModeConfigurationBasedSnapshotSchema;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotSchema() {
        return this.snapshotModeConfigurationBasedSnapshotSchema;
    }

    public void setSignalPollIntervalMs(long signalPollIntervalMs) {
        this.signalPollIntervalMs = signalPollIntervalMs;
    }

    public long getSignalPollIntervalMs() {
        return this.signalPollIntervalMs;
    }

    public void setPostProcessors(String postProcessors) {
        this.postProcessors = postProcessors;
    }

    public String getPostProcessors() {
        return this.postProcessors;
    }

    public void setNotificationEnabledChannels(String notificationEnabledChannels) {
        this.notificationEnabledChannels = notificationEnabledChannels;
    }

    public String getNotificationEnabledChannels() {
        return this.notificationEnabledChannels;
    }

    public void setMongodbSocketTimeoutMs(int mongodbSocketTimeoutMs) {
        this.mongodbSocketTimeoutMs = mongodbSocketTimeoutMs;
    }

    public int getMongodbSocketTimeoutMs() {
        return this.mongodbSocketTimeoutMs;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setNotificationSinkTopicName(String notificationSinkTopicName) {
        this.notificationSinkTopicName = notificationSinkTopicName;
    }

    public String getNotificationSinkTopicName() {
        return this.notificationSinkTopicName;
    }

    public void setSnapshotModeCustomName(String snapshotModeCustomName) {
        this.snapshotModeCustomName = snapshotModeCustomName;
    }

    public String getSnapshotModeCustomName() {
        return this.snapshotModeCustomName;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setMongodbSslInvalidHostnameAllowed(boolean mongodbSslInvalidHostnameAllowed) {
        this.mongodbSslInvalidHostnameAllowed = mongodbSslInvalidHostnameAllowed;
    }

    public boolean isMongodbSslInvalidHostnameAllowed() {
        return this.mongodbSslInvalidHostnameAllowed;
    }

    public void setMongodbHeartbeatFrequencyMs(int mongodbHeartbeatFrequencyMs) {
        this.mongodbHeartbeatFrequencyMs = mongodbHeartbeatFrequencyMs;
    }

    public int getMongodbHeartbeatFrequencyMs() {
        return this.mongodbHeartbeatFrequencyMs;
    }

    public void setDatabaseIncludeList(String databaseIncludeList) {
        this.databaseIncludeList = databaseIncludeList;
    }

    public String getDatabaseIncludeList() {
        return this.databaseIncludeList;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "transaction.metadata.factory", this.transactionMetadataFactory);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "streaming.delay.ms", Long.valueOf(this.streamingDelayMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "custom.metric.tags", this.customMetricTags);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.connection.string", this.mongodbConnectionString);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.password", this.mongodbPassword);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "query.fetch.size", Integer.valueOf(this.queryFetchSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.enabled.channels", this.signalEnabledChannels);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.ssl.enabled", Boolean.valueOf(this.mongodbSslEnabled));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "cursor.max.await.time.ms", Integer.valueOf(this.cursorMaxAwaitTimeMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "field.renames", this.fieldRenames);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.server.selection.timeout.ms", Integer.valueOf(this.mongodbServerSelectionTimeoutMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.data.collection", this.signalDataCollection);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "converters", this.converters);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.connect.timeout.ms", Integer.valueOf(this.mongodbConnectTimeoutMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.poll.interval.ms", Long.valueOf(this.mongodbPollIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.watermarking.strategy", this.incrementalSnapshotWatermarkingStrategy);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.user", this.mongodbUser);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.schema.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnSchemaError));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.collection.filter.overrides", this.snapshotCollectionFilterOverrides);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "field.exclude.list", this.fieldExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "errors.max.retries", Integer.valueOf(this.errorsMaxRetries));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.exclude.list", this.databaseExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "skipped.operations", this.skippedOperations);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.naming.strategy", this.topicNamingStrategy);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.data", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotData));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "collection.include.list", this.collectionIncludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "retriable.restart.connector.wait.ms", Long.valueOf(this.retriableRestartConnectorWaitMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "capture.mode", this.captureMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "provide.transaction.metadata", Boolean.valueOf(this.provideTransactionMetadata));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.data.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnDataError));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.file.filename", this.schemaHistoryInternalFileFilename);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.prefix", this.topicPrefix);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "sourceinfo.struct.maker", this.sourceinfoStructMaker);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.authsource", this.mongodbAuthsource);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "collection.exclude.list", this.collectionExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.include.collection.list", this.snapshotIncludeCollectionList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.start.stream", Boolean.valueOf(this.snapshotModeConfigurationBasedStartStream));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size.in.bytes", Long.valueOf(this.maxQueueSizeInBytes));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.schema", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotSchema));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.poll.interval.ms", Long.valueOf(this.signalPollIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "post.processors", this.postProcessors);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.enabled.channels", this.notificationEnabledChannels);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.socket.timeout.ms", Integer.valueOf(this.mongodbSocketTimeoutMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "event.processing.failure.handling.mode", this.eventProcessingFailureHandlingMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.max.threads", Integer.valueOf(this.snapshotMaxThreads));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.sink.topic.name", this.notificationSinkTopicName);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.custom.name", this.snapshotModeCustomName);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.name.adjustment.mode", this.schemaNameAdjustmentMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.ssl.invalid.hostname.allowed", Boolean.valueOf(this.mongodbSslInvalidHostnameAllowed));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.heartbeat.frequency.ms", Integer.valueOf(this.mongodbHeartbeatFrequencyMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.include.list", this.databaseIncludeList);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return MongoDbConnector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.mongodbPassword)) {
            return ConfigurationValidation.notValid("Required field 'mongodbPassword' must be set.");
        }
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.topicPrefix)) {
            return ConfigurationValidation.notValid("Required field 'topicPrefix' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "mongodb";
    }
}

