/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class PostgresConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,postgres";
    @UriParam(label="consumer,postgres", defaultValue="none")
    private String snapshotLockingMode = "none";
    @UriParam(label="consumer,postgres")
    private String messageKeyColumns;
    @UriParam(label="consumer,postgres", defaultValue="io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory")
    private String transactionMetadataFactory = "io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory";
    @UriParam(label="consumer,postgres")
    private String customMetricTags;
    @UriParam(label="consumer,postgres", defaultValue="dbz_publication")
    private String publicationName = "dbz_publication";
    @UriParam(label="consumer,postgres", defaultValue="source")
    private String signalEnabledChannels = "source";
    @UriParam(label="consumer,postgres", defaultValue="6")
    private int slotMaxRetries = 6;
    @UriParam(label="consumer,postgres", defaultValue="columns_diff")
    private String schemaRefreshMode = "columns_diff";
    @UriParam(label="consumer,postgres", defaultValue="prefer")
    private String databaseSslmode = "prefer";
    @UriParam(label="consumer,postgres")
    private String signalDataCollection;
    @UriParam(label="consumer,postgres")
    private String databaseInitialStatements;
    @UriParam(label="consumer,postgres")
    private String converters;
    @UriParam(label="consumer,postgres")
    private String databaseSslfactory;
    @UriParam(label="consumer,postgres")
    private int snapshotFetchSize;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,postgres")
    private String databaseDbname;
    @UriParam(label="consumer,postgres")
    private String databaseSslkey;
    @UriParam(label="consumer,postgres", defaultValue="disabled")
    private String snapshotTablesOrderByRowCount = "disabled";
    @UriParam(label="consumer,postgres")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,postgres")
    private String databaseSslpassword;
    @UriParam(label="consumer,postgres")
    private String tableExcludeList;
    @UriParam(label="consumer,postgres")
    private String databaseSslrootcert;
    @UriParam(label="consumer,postgres", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,postgres", defaultValue="io.debezium.schema.SchemaTopicNamingStrategy")
    private String topicNamingStrategy = "io.debezium.schema.SchemaTopicNamingStrategy";
    @UriParam(label="consumer,postgres", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotData = false;
    @UriParam(label="consumer,postgres", defaultValue="debezium")
    private String slotName = "debezium";
    @UriParam(label="consumer,postgres", defaultValue="1024")
    private int incrementalSnapshotChunkSize = 1024;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnDataError = false;
    @UriParam(label="consumer,postgres")
    private String schemaHistoryInternalFileFilename;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,postgres", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,postgres", defaultValue="bytes")
    private String binaryHandlingMode = "bytes";
    @UriParam(label="consumer,postgres")
    private String snapshotQueryModeCustomName;
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,postgres")
    private String schemaExcludeList;
    @UriParam(label="consumer,postgres")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedStartStream = false;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean slotDropOnStop = false;
    @UriParam(label="consumer,postgres", defaultValue="5s", javaType="java.time.Duration")
    private long signalPollIntervalMs = 5000L;
    @UriParam(label="consumer,postgres")
    private String notificationEnabledChannels;
    @UriParam(label="consumer,postgres", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,postgres", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,postgres")
    private String notificationSinkTopicName;
    @UriParam(label="consumer,postgres")
    private String snapshotModeCustomName;
    @UriParam(label="consumer,postgres", defaultValue="none")
    private String schemaNameAdjustmentMode = "none";
    @UriParam(label="consumer,postgres")
    private String tableIncludeList;
    @UriParam(label="consumer,postgres")
    private String slotStreamParams;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private long streamingDelayMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="10m", javaType="java.time.Duration")
    private int databaseQueryTimeoutMs = 600000;
    @UriParam(label="consumer,postgres", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,postgres")
    private String schemaIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="__debezium_unavailable_value")
    private String unavailableValuePlaceholder = "__debezium_unavailable_value";
    @UriParam(label="consumer,postgres")
    private String heartbeatActionQuery;
    @UriParam(label="consumer,postgres")
    private String replicaIdentityAutosetValues;
    @UriParam(label="consumer,postgres")
    private String databaseSslcert;
    @UriParam(label="consumer,postgres", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,postgres", defaultValue="numeric")
    private String intervalHandlingMode = "numeric";
    @UriParam(label="consumer,postgres", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private int statusUpdateIntervalMs = 10000;
    @UriParam(label="consumer,postgres")
    private String databaseUser;
    @UriParam(label="consumer,postgres")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,postgres", defaultValue="INSERT_INSERT")
    private String incrementalSnapshotWatermarkingStrategy = "INSERT_INSERT";
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnSchemaError = false;
    @UriParam(label="consumer,postgres")
    private String columnIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="decoderbufs")
    private String pluginName = "decoderbufs";
    @UriParam(label="consumer,postgres")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,postgres", defaultValue="-1")
    private int errorsMaxRetries = -1;
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,postgres", defaultValue="t")
    private String skippedOperations = "t";
    @UriParam(label="consumer,postgres")
    private String messagePrefixIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,postgres", defaultValue="json")
    private String hstoreHandlingMode = "json";
    @UriParam(label="consumer,postgres")
    private String snapshotLockingModeCustomName;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,postgres", defaultValue="select_all")
    private String snapshotQueryMode = "select_all";
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String topicPrefix;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long slotRetryDelayMs = 10000L;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean includeSchemaComments = false;
    @UriParam(label="consumer,postgres", defaultValue="io.debezium.connector.postgresql.PostgresSourceInfoStructMaker")
    private String sourceinfoStructMaker = "io.debezium.connector.postgresql.PostgresSourceInfoStructMaker";
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean flushLsnSource = true;
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean databaseTcpkeepalive = true;
    @UriParam(label="consumer,postgres", defaultValue="all_tables")
    private String publicationAutocreateMode = "all_tables";
    @UriParam(label="consumer,postgres", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private long xminFetchIntervalMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotSchema = false;
    @UriParam(label="consumer,postgres", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,postgres")
    private String messagePrefixExcludeList;
    @UriParam(label="consumer,postgres")
    private String postProcessors;
    @UriParam(label="consumer,postgres", defaultValue="5432")
    private int databasePort = 5432;
    @UriParam(label="consumer,postgres")
    private String columnExcludeList;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean includeUnknownDatatypes = false;
    @UriParam(label="consumer,postgres")
    private String databaseHostname;

    public void setSnapshotLockingMode(String snapshotLockingMode) {
        this.snapshotLockingMode = snapshotLockingMode;
    }

    public String getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setTransactionMetadataFactory(String transactionMetadataFactory) {
        this.transactionMetadataFactory = transactionMetadataFactory;
    }

    public String getTransactionMetadataFactory() {
        return this.transactionMetadataFactory;
    }

    public void setCustomMetricTags(String customMetricTags) {
        this.customMetricTags = customMetricTags;
    }

    public String getCustomMetricTags() {
        return this.customMetricTags;
    }

    public void setPublicationName(String publicationName) {
        this.publicationName = publicationName;
    }

    public String getPublicationName() {
        return this.publicationName;
    }

    public void setSignalEnabledChannels(String signalEnabledChannels) {
        this.signalEnabledChannels = signalEnabledChannels;
    }

    public String getSignalEnabledChannels() {
        return this.signalEnabledChannels;
    }

    public void setSlotMaxRetries(int slotMaxRetries) {
        this.slotMaxRetries = slotMaxRetries;
    }

    public int getSlotMaxRetries() {
        return this.slotMaxRetries;
    }

    public void setSchemaRefreshMode(String schemaRefreshMode) {
        this.schemaRefreshMode = schemaRefreshMode;
    }

    public String getSchemaRefreshMode() {
        return this.schemaRefreshMode;
    }

    public void setDatabaseSslmode(String databaseSslmode) {
        this.databaseSslmode = databaseSslmode;
    }

    public String getDatabaseSslmode() {
        return this.databaseSslmode;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setDatabaseInitialStatements(String databaseInitialStatements) {
        this.databaseInitialStatements = databaseInitialStatements;
    }

    public String getDatabaseInitialStatements() {
        return this.databaseInitialStatements;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setDatabaseSslfactory(String databaseSslfactory) {
        this.databaseSslfactory = databaseSslfactory;
    }

    public String getDatabaseSslfactory() {
        return this.databaseSslfactory;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatabaseSslkey(String databaseSslkey) {
        this.databaseSslkey = databaseSslkey;
    }

    public String getDatabaseSslkey() {
        return this.databaseSslkey;
    }

    public void setSnapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
        this.snapshotTablesOrderByRowCount = snapshotTablesOrderByRowCount;
    }

    public String getSnapshotTablesOrderByRowCount() {
        return this.snapshotTablesOrderByRowCount;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setDatabaseSslpassword(String databaseSslpassword) {
        this.databaseSslpassword = databaseSslpassword;
    }

    public String getDatabaseSslpassword() {
        return this.databaseSslpassword;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setDatabaseSslrootcert(String databaseSslrootcert) {
        this.databaseSslrootcert = databaseSslrootcert;
    }

    public String getDatabaseSslrootcert() {
        return this.databaseSslrootcert;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setTopicNamingStrategy(String topicNamingStrategy) {
        this.topicNamingStrategy = topicNamingStrategy;
    }

    public String getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setSnapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
        this.snapshotModeConfigurationBasedSnapshotData = snapshotModeConfigurationBasedSnapshotData;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotData() {
        return this.snapshotModeConfigurationBasedSnapshotData;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public void setIncrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
        this.incrementalSnapshotChunkSize = incrementalSnapshotChunkSize;
    }

    public int getIncrementalSnapshotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
        this.snapshotModeConfigurationBasedSnapshotOnDataError = snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnDataError() {
        return this.snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public void setSchemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
        this.schemaHistoryInternalFileFilename = schemaHistoryInternalFileFilename;
    }

    public String getSchemaHistoryInternalFileFilename() {
        return this.schemaHistoryInternalFileFilename;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setBinaryHandlingMode(String binaryHandlingMode) {
        this.binaryHandlingMode = binaryHandlingMode;
    }

    public String getBinaryHandlingMode() {
        return this.binaryHandlingMode;
    }

    public void setSnapshotQueryModeCustomName(String snapshotQueryModeCustomName) {
        this.snapshotQueryModeCustomName = snapshotQueryModeCustomName;
    }

    public String getSnapshotQueryModeCustomName() {
        return this.snapshotQueryModeCustomName;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setSchemaExcludeList(String schemaExcludeList) {
        this.schemaExcludeList = schemaExcludeList;
    }

    public String getSchemaExcludeList() {
        return this.schemaExcludeList;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setSnapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
        this.snapshotModeConfigurationBasedStartStream = snapshotModeConfigurationBasedStartStream;
    }

    public boolean isSnapshotModeConfigurationBasedStartStream() {
        return this.snapshotModeConfigurationBasedStartStream;
    }

    public void setSlotDropOnStop(boolean slotDropOnStop) {
        this.slotDropOnStop = slotDropOnStop;
    }

    public boolean isSlotDropOnStop() {
        return this.slotDropOnStop;
    }

    public void setSignalPollIntervalMs(long signalPollIntervalMs) {
        this.signalPollIntervalMs = signalPollIntervalMs;
    }

    public long getSignalPollIntervalMs() {
        return this.signalPollIntervalMs;
    }

    public void setNotificationEnabledChannels(String notificationEnabledChannels) {
        this.notificationEnabledChannels = notificationEnabledChannels;
    }

    public String getNotificationEnabledChannels() {
        return this.notificationEnabledChannels;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setNotificationSinkTopicName(String notificationSinkTopicName) {
        this.notificationSinkTopicName = notificationSinkTopicName;
    }

    public String getNotificationSinkTopicName() {
        return this.notificationSinkTopicName;
    }

    public void setSnapshotModeCustomName(String snapshotModeCustomName) {
        this.snapshotModeCustomName = snapshotModeCustomName;
    }

    public String getSnapshotModeCustomName() {
        return this.snapshotModeCustomName;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    public void setSlotStreamParams(String slotStreamParams) {
        this.slotStreamParams = slotStreamParams;
    }

    public String getSlotStreamParams() {
        return this.slotStreamParams;
    }

    public void setStreamingDelayMs(long streamingDelayMs) {
        this.streamingDelayMs = streamingDelayMs;
    }

    public long getStreamingDelayMs() {
        return this.streamingDelayMs;
    }

    public void setDatabaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
        this.databaseQueryTimeoutMs = databaseQueryTimeoutMs;
    }

    public int getDatabaseQueryTimeoutMs() {
        return this.databaseQueryTimeoutMs;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setSchemaIncludeList(String schemaIncludeList) {
        this.schemaIncludeList = schemaIncludeList;
    }

    public String getSchemaIncludeList() {
        return this.schemaIncludeList;
    }

    public void setUnavailableValuePlaceholder(String unavailableValuePlaceholder) {
        this.unavailableValuePlaceholder = unavailableValuePlaceholder;
    }

    public String getUnavailableValuePlaceholder() {
        return this.unavailableValuePlaceholder;
    }

    public void setHeartbeatActionQuery(String heartbeatActionQuery) {
        this.heartbeatActionQuery = heartbeatActionQuery;
    }

    public String getHeartbeatActionQuery() {
        return this.heartbeatActionQuery;
    }

    public void setReplicaIdentityAutosetValues(String replicaIdentityAutosetValues) {
        this.replicaIdentityAutosetValues = replicaIdentityAutosetValues;
    }

    public String getReplicaIdentityAutosetValues() {
        return this.replicaIdentityAutosetValues;
    }

    public void setDatabaseSslcert(String databaseSslcert) {
        this.databaseSslcert = databaseSslcert;
    }

    public String getDatabaseSslcert() {
        return this.databaseSslcert;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setIntervalHandlingMode(String intervalHandlingMode) {
        this.intervalHandlingMode = intervalHandlingMode;
    }

    public String getIntervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setStatusUpdateIntervalMs(int statusUpdateIntervalMs) {
        this.statusUpdateIntervalMs = statusUpdateIntervalMs;
    }

    public int getStatusUpdateIntervalMs() {
        return this.statusUpdateIntervalMs;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setIncrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
        this.incrementalSnapshotWatermarkingStrategy = incrementalSnapshotWatermarkingStrategy;
    }

    public String getIncrementalSnapshotWatermarkingStrategy() {
        return this.incrementalSnapshotWatermarkingStrategy;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
        this.snapshotModeConfigurationBasedSnapshotOnSchemaError = snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnSchemaError() {
        return this.snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setErrorsMaxRetries(int errorsMaxRetries) {
        this.errorsMaxRetries = errorsMaxRetries;
    }

    public int getErrorsMaxRetries() {
        return this.errorsMaxRetries;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setMessagePrefixIncludeList(String messagePrefixIncludeList) {
        this.messagePrefixIncludeList = messagePrefixIncludeList;
    }

    public String getMessagePrefixIncludeList() {
        return this.messagePrefixIncludeList;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setHstoreHandlingMode(String hstoreHandlingMode) {
        this.hstoreHandlingMode = hstoreHandlingMode;
    }

    public String getHstoreHandlingMode() {
        return this.hstoreHandlingMode;
    }

    public void setSnapshotLockingModeCustomName(String snapshotLockingModeCustomName) {
        this.snapshotLockingModeCustomName = snapshotLockingModeCustomName;
    }

    public String getSnapshotLockingModeCustomName() {
        return this.snapshotLockingModeCustomName;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setSnapshotQueryMode(String snapshotQueryMode) {
        this.snapshotQueryMode = snapshotQueryMode;
    }

    public String getSnapshotQueryMode() {
        return this.snapshotQueryMode;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setSlotRetryDelayMs(long slotRetryDelayMs) {
        this.slotRetryDelayMs = slotRetryDelayMs;
    }

    public long getSlotRetryDelayMs() {
        return this.slotRetryDelayMs;
    }

    public void setIncludeSchemaComments(boolean includeSchemaComments) {
        this.includeSchemaComments = includeSchemaComments;
    }

    public boolean isIncludeSchemaComments() {
        return this.includeSchemaComments;
    }

    public void setSourceinfoStructMaker(String sourceinfoStructMaker) {
        this.sourceinfoStructMaker = sourceinfoStructMaker;
    }

    public String getSourceinfoStructMaker() {
        return this.sourceinfoStructMaker;
    }

    public void setFlushLsnSource(boolean flushLsnSource) {
        this.flushLsnSource = flushLsnSource;
    }

    public boolean isFlushLsnSource() {
        return this.flushLsnSource;
    }

    public void setDatabaseTcpkeepalive(boolean databaseTcpkeepalive) {
        this.databaseTcpkeepalive = databaseTcpkeepalive;
    }

    public boolean isDatabaseTcpkeepalive() {
        return this.databaseTcpkeepalive;
    }

    public void setPublicationAutocreateMode(String publicationAutocreateMode) {
        this.publicationAutocreateMode = publicationAutocreateMode;
    }

    public String getPublicationAutocreateMode() {
        return this.publicationAutocreateMode;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setXminFetchIntervalMs(long xminFetchIntervalMs) {
        this.xminFetchIntervalMs = xminFetchIntervalMs;
    }

    public long getXminFetchIntervalMs() {
        return this.xminFetchIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
        this.snapshotModeConfigurationBasedSnapshotSchema = snapshotModeConfigurationBasedSnapshotSchema;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotSchema() {
        return this.snapshotModeConfigurationBasedSnapshotSchema;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setMessagePrefixExcludeList(String messagePrefixExcludeList) {
        this.messagePrefixExcludeList = messagePrefixExcludeList;
    }

    public String getMessagePrefixExcludeList() {
        return this.messagePrefixExcludeList;
    }

    public void setPostProcessors(String postProcessors) {
        this.postProcessors = postProcessors;
    }

    public String getPostProcessors() {
        return this.postProcessors;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setIncludeUnknownDatatypes(boolean includeUnknownDatatypes) {
        this.includeUnknownDatatypes = includeUnknownDatatypes;
    }

    public boolean isIncludeUnknownDatatypes() {
        return this.includeUnknownDatatypes;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.locking.mode", this.snapshotLockingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.key.columns", this.messageKeyColumns);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "transaction.metadata.factory", this.transactionMetadataFactory);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "custom.metric.tags", this.customMetricTags);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "publication.name", this.publicationName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.enabled.channels", this.signalEnabledChannels);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.max.retries", Integer.valueOf(this.slotMaxRetries));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.refresh.mode", this.schemaRefreshMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslmode", this.databaseSslmode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.data.collection", this.signalDataCollection);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.initial.statements", this.databaseInitialStatements);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "converters", this.converters);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslfactory", this.databaseSslfactory);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.lock.timeout.ms", Long.valueOf(this.snapshotLockTimeoutMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.dbname", this.databaseDbname);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslkey", this.databaseSslkey);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.tables.order.by.row.count", this.snapshotTablesOrderByRowCount);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.select.statement.overrides", this.snapshotSelectStatementOverrides);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslpassword", this.databaseSslpassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.exclude.list", this.tableExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslrootcert", this.databaseSslrootcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.naming.strategy", this.topicNamingStrategy);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.data", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotData));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.name", this.slotName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.chunk.size", Integer.valueOf(this.incrementalSnapshotChunkSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "retriable.restart.connector.wait.ms", Long.valueOf(this.retriableRestartConnectorWaitMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.data.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnDataError));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.file.filename", this.schemaHistoryInternalFileFilename);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "decimal.handling.mode", this.decimalHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "binary.handling.mode", this.binaryHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.query.mode.custom.name", this.snapshotQueryModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.ignore.builtin", Boolean.valueOf(this.tableIgnoreBuiltin));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.exclude.list", this.schemaExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.include.collection.list", this.snapshotIncludeCollectionList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.start.stream", Boolean.valueOf(this.snapshotModeConfigurationBasedStartStream));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.drop.on.stop", Boolean.valueOf(this.slotDropOnStop));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.poll.interval.ms", Long.valueOf(this.signalPollIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.enabled.channels", this.notificationEnabledChannels);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "event.processing.failure.handling.mode", this.eventProcessingFailureHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.max.threads", Integer.valueOf(this.snapshotMaxThreads));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.sink.topic.name", this.notificationSinkTopicName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.custom.name", this.snapshotModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.name.adjustment.mode", this.schemaNameAdjustmentMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.include.list", this.tableIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.stream.params", this.slotStreamParams);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "streaming.delay.ms", Long.valueOf(this.streamingDelayMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.query.timeout.ms", Integer.valueOf(this.databaseQueryTimeoutMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "query.fetch.size", Integer.valueOf(this.queryFetchSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.include.list", this.schemaIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "unavailable.value.placeholder", this.unavailableValuePlaceholder);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.action.query", this.heartbeatActionQuery);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "replica.identity.autoset.values", this.replicaIdentityAutosetValues);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslcert", this.databaseSslcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "interval.handling.mode", this.intervalHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "status.update.interval.ms", Integer.valueOf(this.statusUpdateIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.user", this.databaseUser);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "datatype.propagate.source.type", this.datatypePropagateSourceType);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.watermarking.strategy", this.incrementalSnapshotWatermarkingStrategy);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.schema.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnSchemaError));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.include.list", this.columnIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "plugin.name", this.pluginName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.propagate.source.type", this.columnPropagateSourceType);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "errors.max.retries", Integer.valueOf(this.errorsMaxRetries));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.password", this.databasePassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "skipped.operations", this.skippedOperations);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.prefix.include.list", this.messagePrefixIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "hstore.handling.mode", this.hstoreHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.locking.mode.custom.name", this.snapshotLockingModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "provide.transaction.metadata", Boolean.valueOf(this.provideTransactionMetadata));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.query.mode", this.snapshotQueryMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.prefix", this.topicPrefix);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.retry.delay.ms", Long.valueOf(this.slotRetryDelayMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.schema.comments", Boolean.valueOf(this.includeSchemaComments));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "sourceinfo.struct.maker", this.sourceinfoStructMaker);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "flush.lsn.source", Boolean.valueOf(this.flushLsnSource));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.tcpKeepAlive", Boolean.valueOf(this.databaseTcpkeepalive));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "publication.autocreate.mode", this.publicationAutocreateMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size.in.bytes", Long.valueOf(this.maxQueueSizeInBytes));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "xmin.fetch.interval.ms", Long.valueOf(this.xminFetchIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.schema", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotSchema));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "time.precision.mode", this.timePrecisionMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.prefix.exclude.list", this.messagePrefixExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "post.processors", this.postProcessors);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.port", Integer.valueOf(this.databasePort));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.exclude.list", this.columnExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.unknown.datatypes", Boolean.valueOf(this.includeUnknownDatatypes));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.hostname", this.databaseHostname);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return PostgresConnector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databasePassword)) {
            return ConfigurationValidation.notValid("Required field 'databasePassword' must be set.");
        }
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.topicPrefix)) {
            return ConfigurationValidation.notValid("Required field 'topicPrefix' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "postgres";
    }
}

