/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.component.directvm;

import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.karaf.component.directvm.DirectVmComponent;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.AntPathMatcher;

public class DirectVmConsumerExpression
extends ExpressionAdapter {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final String pattern;

    public DirectVmConsumerExpression(String pattern) {
        this.pattern = pattern;
    }

    public Object evaluate(Exchange exchange) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : DirectVmComponent.getConsumerEndpoints()) {
            if (!this.matcher.match(this.pattern, endpoint.getEndpointKey())) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public String toString() {
        return "DirectVmConsumerExpression[" + this.pattern + "]";
    }
}

