/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.zoo.ModelNotFoundException;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.apache.camel.component.djl.model.audio.CustomAudioPredictor;
import org.apache.camel.component.djl.model.audio.ZooAudioPredictor;
import org.apache.camel.component.djl.model.cv.CustomCvPredictor;
import org.apache.camel.component.djl.model.cv.CustomImageGenerationPredictor;
import org.apache.camel.component.djl.model.cv.ZooActionRecognitionPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageClassificationPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageEnhancementPredictor;
import org.apache.camel.component.djl.model.cv.ZooImageGenerationPredictor;
import org.apache.camel.component.djl.model.cv.ZooInstanceSegmentationPredictor;
import org.apache.camel.component.djl.model.cv.ZooObjectDetectionPredictor;
import org.apache.camel.component.djl.model.cv.ZooPoseEstimationPredictor;
import org.apache.camel.component.djl.model.cv.ZooSemanticSegmentationPredictor;
import org.apache.camel.component.djl.model.cv.ZooWordRecognitionPredictor;
import org.apache.camel.component.djl.model.nlp.CustomNlpPredictor;
import org.apache.camel.component.djl.model.nlp.CustomQuestionAnswerPredictor;
import org.apache.camel.component.djl.model.nlp.CustomWordEmbeddingPredictor;
import org.apache.camel.component.djl.model.nlp.ZooFillMaskPredictor;
import org.apache.camel.component.djl.model.nlp.ZooMachineTranslationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooMultipleChoicePredictor;
import org.apache.camel.component.djl.model.nlp.ZooQuestionAnswerPredictor;
import org.apache.camel.component.djl.model.nlp.ZooSentimentAnalysisPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextClassificationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextEmbeddingPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTextGenerationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooTokenClassificationPredictor;
import org.apache.camel.component.djl.model.nlp.ZooWordEmbeddingPredictor;
import org.apache.camel.component.djl.model.tabular.CustomTabularPredictor;
import org.apache.camel.component.djl.model.tabular.ZooLinearRegressionPredictor;
import org.apache.camel.component.djl.model.tabular.ZooSoftmaxRegressionPredictor;
import org.apache.camel.component.djl.model.timeseries.CustomForecastingPredictor;
import org.apache.camel.component.djl.model.timeseries.ZooForecastingPredictor;

public final class ModelPredictorProducer {
    private ModelPredictorProducer() {
    }

    public static AbstractPredictor getZooPredictor(DJLEndpoint endpoint) throws ModelNotFoundException, MalformedModelException, IOException {
        String applicationPath = endpoint.getApplication();
        if (Application.CV.IMAGE_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooImageClassificationPredictor(endpoint);
        }
        if (Application.CV.OBJECT_DETECTION.getPath().equals(applicationPath)) {
            return new ZooObjectDetectionPredictor(endpoint);
        }
        if (Application.CV.SEMANTIC_SEGMENTATION.getPath().equals(applicationPath)) {
            return new ZooSemanticSegmentationPredictor(endpoint);
        }
        if (Application.CV.INSTANCE_SEGMENTATION.getPath().equals(applicationPath)) {
            return new ZooInstanceSegmentationPredictor(endpoint);
        }
        if (Application.CV.POSE_ESTIMATION.getPath().equals(applicationPath)) {
            return new ZooPoseEstimationPredictor(endpoint);
        }
        if (Application.CV.ACTION_RECOGNITION.getPath().equals(applicationPath)) {
            return new ZooActionRecognitionPredictor(endpoint);
        }
        if (Application.CV.WORD_RECOGNITION.getPath().equals(applicationPath)) {
            return new ZooWordRecognitionPredictor(endpoint);
        }
        if (Application.CV.IMAGE_GENERATION.getPath().equals(applicationPath)) {
            return new ZooImageGenerationPredictor(endpoint);
        }
        if (Application.CV.IMAGE_ENHANCEMENT.getPath().equals(applicationPath)) {
            return new ZooImageEnhancementPredictor(endpoint);
        }
        if (Application.NLP.FILL_MASK.getPath().equals(applicationPath)) {
            return new ZooFillMaskPredictor(endpoint);
        }
        if (Application.NLP.QUESTION_ANSWER.getPath().equals(applicationPath)) {
            return new ZooQuestionAnswerPredictor(endpoint);
        }
        if (Application.NLP.TEXT_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooTextClassificationPredictor(endpoint);
        }
        if (Application.NLP.SENTIMENT_ANALYSIS.getPath().equals(applicationPath)) {
            return new ZooSentimentAnalysisPredictor(endpoint);
        }
        if (Application.NLP.TOKEN_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new ZooTokenClassificationPredictor(endpoint);
        }
        if (Application.NLP.WORD_EMBEDDING.getPath().equals(applicationPath)) {
            return new ZooWordEmbeddingPredictor(endpoint);
        }
        if (Application.NLP.TEXT_GENERATION.getPath().equals(applicationPath)) {
            return new ZooTextGenerationPredictor(endpoint);
        }
        if (Application.NLP.MACHINE_TRANSLATION.getPath().equals(applicationPath)) {
            return new ZooMachineTranslationPredictor(endpoint);
        }
        if (Application.NLP.MULTIPLE_CHOICE.getPath().equals(applicationPath)) {
            return new ZooMultipleChoicePredictor(endpoint);
        }
        if (Application.NLP.TEXT_EMBEDDING.getPath().equals(applicationPath)) {
            return new ZooTextEmbeddingPredictor(endpoint);
        }
        if (Application.Tabular.LINEAR_REGRESSION.getPath().equals(applicationPath)) {
            return new ZooLinearRegressionPredictor(endpoint);
        }
        if (Application.Tabular.SOFTMAX_REGRESSION.getPath().equals(applicationPath)) {
            return new ZooSoftmaxRegressionPredictor(endpoint);
        }
        if (Application.Audio.ANY.getPath().equals(applicationPath)) {
            return new ZooAudioPredictor(endpoint);
        }
        if (Application.TimeSeries.FORECASTING.getPath().equals(applicationPath)) {
            return new ZooForecastingPredictor(endpoint);
        }
        throw new RuntimeCamelException("Application not supported: " + applicationPath);
    }

    public static AbstractPredictor getCustomPredictor(DJLEndpoint endpoint) {
        String applicationPath = endpoint.getApplication();
        if (applicationPath.equals(Application.CV.IMAGE_CLASSIFICATION.getPath())) {
            return new CustomCvPredictor(endpoint);
        }
        if (applicationPath.equals(Application.CV.OBJECT_DETECTION.getPath())) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.SEMANTIC_SEGMENTATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.INSTANCE_SEGMENTATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.POSE_ESTIMATION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.ACTION_RECOGNITION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.WORD_RECOGNITION.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.CV.IMAGE_GENERATION.getPath().equals(applicationPath)) {
            return new CustomImageGenerationPredictor(endpoint);
        }
        if (Application.CV.IMAGE_ENHANCEMENT.getPath().equals(applicationPath)) {
            return new CustomCvPredictor(endpoint);
        }
        if (Application.NLP.FILL_MASK.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.QUESTION_ANSWER.getPath().equals(applicationPath)) {
            return new CustomQuestionAnswerPredictor(endpoint);
        }
        if (Application.NLP.TEXT_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.SENTIMENT_ANALYSIS.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.TOKEN_CLASSIFICATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.WORD_EMBEDDING.getPath().equals(applicationPath)) {
            return new CustomWordEmbeddingPredictor(endpoint);
        }
        if (Application.NLP.TEXT_GENERATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.MACHINE_TRANSLATION.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.MULTIPLE_CHOICE.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.NLP.TEXT_EMBEDDING.getPath().equals(applicationPath)) {
            return new CustomNlpPredictor(endpoint);
        }
        if (Application.Tabular.LINEAR_REGRESSION.getPath().equals(applicationPath)) {
            return new CustomTabularPredictor(endpoint);
        }
        if (Application.Tabular.SOFTMAX_REGRESSION.getPath().equals(applicationPath)) {
            return new CustomTabularPredictor(endpoint);
        }
        if (Application.Audio.ANY.getPath().equals(applicationPath)) {
            return new CustomAudioPredictor(endpoint);
        }
        if (Application.TimeSeries.FORECASTING.getPath().equals(applicationPath)) {
            return new CustomForecastingPredictor(endpoint);
        }
        throw new RuntimeCamelException("Application not supported: " + applicationPath);
    }
}

