/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.ConfigFileInfo;
import org.apache.drill.common.config.DrillExecConfigFileInfo;
import org.apache.drill.common.config.DrillRMConfigFileInfo;
import org.apache.drill.common.config.NestedConfig;
import org.apache.drill.common.exceptions.DrillConfigurationException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(DrillConfig.class);
    private final ImmutableList<String> startupArguments;
    private static final long MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory();

    @VisibleForTesting
    public DrillConfig(Config config) {
        super(config);
        logger.debug("Setting up DrillConfig object.");
        logger.trace("Given Config object is:\n{}", (Object)config.withoutPath("password").withoutPath("sun.java.command").root().render(ConfigRenderOptions.defaults()));
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        this.startupArguments = ImmutableList.copyOf(bean.getInputArguments());
        logger.debug("DrillConfig object initialized.");
    }

    public <T> T getInstance(String path, Class<T> iface, Object ... constructorArgs) {
        try {
            String className = this.getString(path);
            Class<?> clazz = Class.forName(className);
            Preconditions.checkArgument(iface.isAssignableFrom(clazz));
            Class[] argClasses = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                argClasses[i] = constructorArgs[i].getClass();
            }
            Constructor<?> constructor = clazz.getConstructor(argClasses);
            return (T)constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to load instance of the class of type %s requested at path %s.", iface.getName(), path).build(logger);
        }
    }

    public List<String> getStartupArguments() {
        return this.startupArguments;
    }

    public static DrillConfig create() {
        return DrillConfig.create(null, true);
    }

    public static DrillConfig forClient() {
        return DrillConfig.create(null, false);
    }

    public static DrillConfig create(String overrideFileResourcePathname) {
        return DrillConfig.create(overrideFileResourcePathname, true);
    }

    @VisibleForTesting
    public static DrillConfig create(Properties testConfigurations) {
        return DrillConfig.create(null, testConfigurations, true, new DrillExecConfigFileInfo(), null);
    }

    public static DrillConfig create(String overrideFileResourcePathname, boolean enableServerConfigs) {
        return DrillConfig.create(overrideFileResourcePathname, null, enableServerConfigs, new DrillExecConfigFileInfo(), null);
    }

    public static DrillConfig createForRM() {
        return DrillConfig.create(null, null, true, new DrillRMConfigFileInfo(), null);
    }

    public static DrillConfig create(Config config) {
        return new DrillConfig(config.resolve());
    }

    public static DrillConfig create(String overrideFileResourcePathname, Properties overriderProps, boolean enableServerConfigs, ConfigFileInfo configInfo, ConfigMergeable fallbackConfig) {
        ClassLoader classLoader;
        URL distribConfigFileUrl;
        String perModuleResourcePathName;
        ClassLoader[] classLoaders;
        StringBuilder logString = new StringBuilder();
        Stopwatch watch = Stopwatch.createStarted();
        overrideFileResourcePathname = overrideFileResourcePathname == null ? configInfo.getOverrideFileName() : overrideFileResourcePathname;
        Config fallback = ConfigFactory.empty();
        for (ClassLoader classLoader2 : classLoaders = ClasspathHelper.classLoaders((ClassLoader[])new ClassLoader[0])) {
            URL url = classLoader2.getResource(configInfo.getDefaultFileName());
            if (null == url) continue;
            logString.append("Base Configuration:\n\t- ").append(url).append("\n");
            fallback = ConfigFactory.load((ClassLoader)classLoader2, (String)configInfo.getDefaultFileName());
            break;
        }
        ArrayList urls = (perModuleResourcePathName = configInfo.getModuleFileName()) != null ? ClassPathScanner.getConfigURLs(perModuleResourcePathName) : new ArrayList();
        logString.append("\nIntermediate Configuration and Plugin files, in order of precedence:\n");
        for (URL url : urls) {
            logString.append("\t- ").append(url).append("\n");
            fallback = ConfigFactory.parseURL((URL)url).withFallback((ConfigMergeable)fallback);
        }
        logString.append("\n");
        if (fallbackConfig != null) {
            fallback = fallback.withFallback(fallbackConfig);
        }
        if ((distribConfigFileUrl = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(configInfo.getDistributionFileName())) != null) {
            logString.append("Distribution Specific Configuration File: ").append(distribConfigFileUrl).append("\n");
        }
        fallback = ConfigFactory.load((String)configInfo.getDistributionFileName()).withFallback((ConfigMergeable)fallback);
        URL overrideFileUrl = classLoader.getResource(overrideFileResourcePathname);
        if (overrideFileUrl != null) {
            logString.append("Override File: ").append(overrideFileUrl).append("\n");
        }
        Config effectiveConfig = ConfigFactory.load((String)overrideFileResourcePathname).withFallback((ConfigMergeable)fallback);
        if (overriderProps != null) {
            logString.append("Overridden Properties:\n");
            for (Map.Entry<Object, Object> entry : overriderProps.entrySet()) {
                if (entry.getKey().equals("password")) continue;
                logString.append("\t-").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            logString.append("\n");
            effectiveConfig = ConfigFactory.parseProperties((Properties)overriderProps).withFallback((ConfigMergeable)effectiveConfig);
        }
        logger.info("Configuration and plugin file(s) identified in {}ms.\n{}", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)logString);
        return new DrillConfig(effectiveConfig.resolve());
    }

    private <T> Class<T> getClassAt(String location, Class<T> clazz) throws DrillConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            throw new DrillConfigurationException(String.format("No class defined at location '%s'. Expected a definition of the class [%s]", location, clazz.getCanonicalName()));
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t = c;
                return t;
            }
            throw new DrillConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof DrillConfigurationException) {
                throw (DrillConfigurationException)ex;
            }
            throw new DrillConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws DrillConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new DrillConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    public String toString() {
        return this.root().render();
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }
}

