/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.drill.common.expression.AnyValueExpression;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.ConvertExpression;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ConditionalExprOptimizer
extends AbstractExprVisitor<LogicalExpression, Void, RuntimeException> {
    public static ConditionalExprOptimizer INSTANCE = new ConditionalExprOptimizer();
    private static Comparator<LogicalExpression> costComparator = new Comparator<LogicalExpression>(){

        @Override
        public int compare(LogicalExpression e1, LogicalExpression e2) {
            return e1.getCumulativeCost() <= e2.getCumulativeCost() ? -1 : 1;
        }
    };

    @Override
    public LogicalExpression visitBooleanOperator(BooleanOperator op, Void value) throws RuntimeException {
        ArrayList<LogicalExpression> newArgs = Lists.newArrayList();
        newArgs.addAll(op.args());
        Collections.sort(newArgs, costComparator);
        return new BooleanOperator(op.getName(), newArgs, op.getPosition());
    }

    @Override
    public LogicalExpression visitFunctionHolderExpression(FunctionHolderExpression holder, Void value) throws RuntimeException {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (int i = 0; i < holder.args.size(); ++i) {
            LogicalExpression newExpr = ((LogicalExpression)holder.args.get(i)).accept(this, value);
            assert (newExpr != null);
            args.add(newExpr);
        }
        return holder.copy(args);
    }

    @Override
    public LogicalExpression visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return e;
    }

    @Override
    public LogicalExpression visitIfExpression(IfExpression ifExpr, Void value) throws RuntimeException {
        LogicalExpression newElseExpr = ifExpr.elseExpression.accept(this, value);
        IfExpression.IfCondition conditions = ifExpr.ifCondition;
        LogicalExpression newCondition = conditions.condition.accept(this, value);
        LogicalExpression newExpr = conditions.expression.accept(this, value);
        conditions = new IfExpression.IfCondition(newCondition, newExpr);
        return IfExpression.newBuilder().setElse(newElseExpr).setIfCondition(conditions).build();
    }

    @Override
    public LogicalExpression visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public LogicalExpression visitCastExpression(CastExpression cast, Void value) throws RuntimeException {
        throw new UnsupportedOperationException("CastExpression is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public LogicalExpression visitConvertExpression(ConvertExpression cast, Void value) throws RuntimeException {
        throw new UnsupportedOperationException("ConvertExpression is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public LogicalExpression visitAnyValueExpression(AnyValueExpression cast, Void value) throws RuntimeException {
        throw new UnsupportedOperationException("AnyValueExpression is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }
}

