/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.alias;

import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.NoopAliasRegistry;
import org.apache.drill.exec.alias.PersistentAliasRegistry;
import org.apache.drill.exec.server.DrillbitContext;

public class AliasRegistryProvider
implements AutoCloseable {
    private static final String STORAGE_REGISTRY_PATH = "storage_aliases";
    private static final String TABLE_REGISTRY_PATH = "table_aliases";
    private final DrillbitContext context;
    private AliasRegistry storageAliasesRegistry;
    private AliasRegistry tableAliasesRegistry;

    public AliasRegistryProvider(DrillbitContext context) {
        this.context = context;
    }

    public AliasRegistry getStorageAliasesRegistry() {
        if (this.context.getOptionManager().getBoolean("exec.enable_aliases")) {
            if (this.storageAliasesRegistry == null) {
                this.initRemoteRegistries();
            }
            return this.storageAliasesRegistry;
        }
        return NoopAliasRegistry.INSTANCE;
    }

    public AliasRegistry getTableAliasesRegistry() {
        if (this.context.getOptionManager().getBoolean("exec.enable_aliases")) {
            if (this.tableAliasesRegistry == null) {
                this.initRemoteRegistries();
            }
            return this.tableAliasesRegistry;
        }
        return NoopAliasRegistry.INSTANCE;
    }

    private synchronized void initRemoteRegistries() {
        if (this.storageAliasesRegistry == null) {
            this.storageAliasesRegistry = new PersistentAliasRegistry(this.context, STORAGE_REGISTRY_PATH);
            this.tableAliasesRegistry = new PersistentAliasRegistry(this.context, TABLE_REGISTRY_PATH);
        }
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.closeSilently(this.storageAliasesRegistry, this.tableAliasesRegistry);
    }
}

