/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.alias;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.Aliases;
import org.apache.drill.exec.alias.EmptyAliases;
import org.apache.drill.exec.alias.PersistentAliasesTable;
import org.apache.drill.exec.alias.ResolvedAliases;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;

public class PersistentAliasRegistry
implements AliasRegistry {
    public static final String PUBLIC_ALIASES_KEY = "$public_aliases";
    private final PersistentStore<PersistentAliasesTable> store;
    private final boolean useUserAliases;

    public PersistentAliasRegistry(DrillbitContext context, String registryPath) {
        try {
            ObjectMapper mapper = context.getLpPersistence().getMapper().copy();
            InjectableValues.Std injectables = new InjectableValues.Std().addValue(StoreProvider.class, (Object)new StoreProvider(this::getStore));
            mapper.setInjectableValues((InjectableValues)injectables);
            this.store = context.getStoreProvider().getOrCreateStore(PersistentStoreConfig.newJacksonBuilder(mapper, PersistentAliasesTable.class).name(registryPath).build());
            this.useUserAliases = context.getConfig().getBoolean("drill.exec.impersonation.enabled");
        }
        catch (StoreException e) {
            throw new DrillRuntimeException("Failure while reading and loading alias table.");
        }
    }

    public PersistentStore<PersistentAliasesTable> getStore() {
        return this.store;
    }

    private ResolvedAliases getResolvedAliases(String key) {
        PersistentAliasesTable userAliases = this.useUserAliases ? this.store.get(key) : null;
        return userAliases != null ? new ResolvedAliases(userAliases, this::getPublicAliases) : new ResolvedAliases(EmptyAliases.INSTANCE, this::getPublicAliases);
    }

    @Override
    public Iterator<Map.Entry<String, Aliases>> getAllAliases() {
        return this.store.getAll();
    }

    @Override
    public Aliases getUserAliases(String userName) {
        return this.getResolvedAliases(userName);
    }

    @Override
    public void createUserAliases(String userName) {
        if (!this.store.contains(userName)) {
            PersistentAliasesTable aliasesTable = new PersistentAliasesTable(new HashMap<String, String>(), userName, new StoreProvider(this::getStore));
            this.store.put(userName, aliasesTable);
        }
    }

    @Override
    public void createPublicAliases() {
        if (!this.store.contains(PUBLIC_ALIASES_KEY)) {
            PersistentAliasesTable publicAliases = new PersistentAliasesTable(new HashMap<String, String>(), PUBLIC_ALIASES_KEY, new StoreProvider(this::getStore));
            this.store.put(PUBLIC_ALIASES_KEY, publicAliases);
        }
    }

    @Override
    public void deleteUserAliases(String userName) {
        this.store.delete(userName);
    }

    @Override
    public void deletePublicAliases() {
        this.store.delete(PUBLIC_ALIASES_KEY);
    }

    @Override
    public Aliases getPublicAliases() {
        return Optional.ofNullable((Aliases)this.store.get(PUBLIC_ALIASES_KEY)).orElse(EmptyAliases.INSTANCE);
    }

    @Override
    public void close() throws Exception {
        this.store.close();
    }

    public static class StoreProvider {
        private final Supplier<PersistentStore<PersistentAliasesTable>> supplier;

        public StoreProvider(Supplier<PersistentStore<PersistentAliasesTable>> supplier) {
            this.supplier = supplier;
        }

        public PersistentStore<PersistentAliasesTable> getStore() {
            return this.supplier.get();
        }
    }
}

